# -*- coding: utf-8 -*-
from multiprocessing.pool import Pool
from time import sleep, time
import pandas as pd
import os
import re
import io
import sys


sys.stdout = io.TextIOWrapper(sys.stdout.buffer,encoding='utf-8')
os.chdir("/PATH/Breakdancer/")


def my_cmd(i):
    print("%sProcess ID：%d" % (i, os.getpid()))
    start = time()
    data=pd.read_csv(i,sep='\t',header=None)
    data.columns=['a','b','c','d']
    data=data.sort_values(by='a')
    lis=["%s%s"%("chr",i) for i in range(1,31)]
    times=pd.value_counts(data.iloc[:,0])[list(data.iloc[:,0].drop_duplicates().sort_values())]
    data.iloc[:,0]=sum(([x]*y for x,y in zip(lis, times)),[])
    data.to_csv("/sdb1/usrdata/yanglv/Holstein_result/Breakdancer/"+i.split("_B.")[0]+".breakdancer.txt",sep='\t',header=0,index=None)
    end = time()
    print("%sProcess ID：%d. Time 0.2%f" % (i, os.getpid(), end-start))


if __name__ == "__main__":
    print("start")
    p = Pool(40)
    for i in [i for i in os.listdir() if i[-3:].endswith("txt")]:
        p.apply_async(my_cmd, args=(i,))
        
    p.close()
    p.join()
    print("end")
