# Bovine TE Evolution

## Scripts and files used in:
Kelly CJ, Chitko-McKown C, Chuong EB. 2022. Ruminant-specific retrotransposons shape regulatory evolution of bovine immunity. Genome Research.

## Data availability:
All raw and processed sequencing data generated in this study have been submitted to the NCBI Gene Expression Omnibus (GEO) with accession number [GSE185082](https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE185082).

## Programs used:
List of programs used for all analyses.
* BBMap v38.05 (https://jgi.doe.gov/data-and-tools/bbtools/)
* bedtools v2.28.0 (http://bedtools.readthedocs.io/en/latest/)
* Bowtie2 v2.2.9 (http://bowtie-bio.sourceforge.net/bowtie2/index.shtml)
* BWA v0.7.15 (https://github.com/lh3/bwa)
* deepTools v3.5.1 (https://deeptools.readthedocs.io/en/develop/index.html)
* DESeq2 v1.26.0 (https://bioconductor.org/packages/release/bioc/html/DESeq2.html)
* FastQC v0.11.8 (https://github.com/s-andrews/FastQC)
* HISAT2 v2.1.0 (https://github.com/DaehwanKimLab/hisat2)
* MACS v2.1.1 (https://pypi.org/project/MACS2/)
* MELT v2.1.5 (https://melt.igs.umaryland.edu/index.php)
* MultiQC v1.7 (https://github.com/ewels/MultiQC)
* Picard v2.6.0 (https://broadinstitute.github.io/picard/)
* QualiMap v2.2.1 (http://qualimap.conesalab.org/)
* RepeatMasker v4.1.0 (https://www.repeatmasker.org/)
* Sambamba v0.6.9 (https://lomereiter.github.io/sambamba/)
* Samtools v1.10 (http://www.htslib.org/)
* SRA Toolkit v2.10.5 (https://github.com/ncbi/sra-tools)
* Subread v1.6.2 (http://subread.sourceforge.net/)

For the most up-to-date scripts, see https://github.com/coke6162/bovine_TE_evolution.