#ifndef _EXPERT_
#define _EXPERT_
#include <vector>
using namespace std;
#include "gsl/gsl_randist.h"
#include "CommonTypes.H"
#define PI 3.1472
class Matrix;
class DRMNPotential;
//class Evidence;
class Expert
{
	public:
		Expert();
		~Expert();
		int setMean(Matrix*);
		int setCovariance(Matrix*);
		double getOutputPDF(vector<double>* y);
		double getOutputPDF_Nocov(vector<double>* y);
		int setPrior(double);
		double getPrior();
		Matrix* getMean();
		Matrix* getCovariance();
		int updateCovariance();
		int assignGeneToExpert(const char*);
		map<string,int>& getGeneSet();
		int resetAssignedGenes();
		double getEntropy();
		int generateSample(gsl_rng* r, vector<double>&);
		int resetClip();
		int getClip();
		inline double getMinPDF()
		{
			return minpdf;
		}
		int addRegulator(string&);
		map<string,int>& getCurrentRegSet();
		//New to support DRMNs
		int setLLScore(double);
		double getLLScore();
		int setDRMNPotential(DRMNPotential*);
		DRMNPotential* getDRMNPotential();
		//double getDRMNProb(map<int,Evidence*>* evidSet);
		double getDRMNProb(map<int,double>* evidSet);
	private:
		 Matrix* covariance;
		 Matrix* invCovariance;
		 Matrix* mean;
		 double normFactor;
		 map<string,int> geneSet;
		double priorProb;
		int clipCnt;
		double minpdf;
		map<string,int> regulators;
		double llScore;
		//This is needed in order for us to be able to re-assign genes based on their posterior prob 
		//of being generated by the expert
		DRMNPotential* dPot;
};
#endif

