# Analysis codes for Lee et al. 2022
This repository contains major scripts used in data processing and plotting for ***Epigenomic analysis reveals prevalent contribution of transposable elements to cis-regulatory elements, tissue-specific expression, and alternative promoters in zebrafish***.

## Project summary
Transposable elements (TEs) encode regulatory elements that impact gene expression in multiple species, yet a comprehensive analysis of zebrafish TEs in the context of gene regulation is lacking. Here, we systematically investigate the epigenomic and transcriptomic landscape of TEs across eleven adult zebrafish tissues using multidimensional sequencing data. We find that TEs contribute substantially to a diverse array of regulatory elements in the zebrafish genome and that 37% of TEs are positioned in active regulatory states in adult zebrafish tissues. We identify TE subfamilies enriched in highly specific regulatory elements among different tissues. We use transcript assembly to discover TE-derived transcriptional units expressed across tissues. Finally, we show that novel TE-derived promoters can initiate tissue-specific transcription of alternate gene isoforms. This work provides a comprehensive profile of TE activity across normal zebrafish tissues, shedding light on mechanisms underlying the regulation of gene expression in this widely used model organism.
