% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_reads.R
\name{sort_index_idxstats_bam}
\alias{sort_index_idxstats_bam}
\title{Sorts, indexes the BAM file, and retrieves the \code{idxstats}.}
\usage{
sort_index_idxstats_bam(
  bam_file,
  sorted_bam_file,
  sort = TRUE,
  index = TRUE,
  idxstats = TRUE
)
}
\arguments{
\item{bam_file}{Input BAM file.}

\item{sorted_bam_file}{Output file name for sorted BAM file if \code{sort=TRUE}.}

\item{sort}{Logical. If TRUE, sorts the BAM file.}

\item{index}{Logical. If TRUE, indexes the BAM file.}

\item{idxstats}{Logical. If TRUE, retrieves \code{idxstats} summary of
the number of mapped reads in each chromosome.}
}
\description{
Sorts and indexes the BAM file, and
retrieves the \code{idxstats} (summary of
the number of mapped reads on every chromosome) using \code{Rsamtools} package.
}
\examples{
\dontrun{
# Sorts, indexes the BAM file, and retrieves the idxstats.
sort_index_idxstats_bam('example.bam', sort=TRUE, index=TRUE, idxstats=TRUE)

# Indexes the BAM file, and retrieves the idxstats, using sorted BAM file.
sort_index_idxstats_bam('example.sorted.bam', sort=FALSE, index=TRUE, idxstats=TRUE)
}
}
