% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{scatterplot_predictions}
\alias{scatterplot_predictions}
\title{Scatter plot of measured and predicted occupancy}
\usage{
scatterplot_predictions(
  x,
  y,
  xlab = "measured",
  ylab = "predicted",
  title = "",
  xlim = c(0, 10),
  ylim = c(0, 10),
  color = "black"
)
}
\arguments{
\item{x}{x-axis values of points in the plot (measured).}

\item{y}{y-axis values of points in the plot (predicted).}

\item{xlab}{Label for the x axis.}

\item{ylab}{Label for the y axis.}

\item{title}{Title for the plot.}

\item{xlim}{Range of x-axis values.}

\item{ylim}{Range of y-axis values.}

\item{color}{The plotting color.}
}
\value{
A \code{ggplot} object for
the scatter plot of measured and predicted occupancy.
}
\description{
Makes a scatter plot of measured and predicted occupancy,
with Pearson's correlation (R) between measured and predicted occupancy.
}
\examples{

\dontrun{
scatterplot_predictions(x = asinh(chip),
                        y = asinh(predicted),
                        xlab = 'asinh(measured occupancy)',
                        ylab = 'asinh(predicted occupancy)')
}
}
