% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_motif_sites.R
\name{process_candidate_sites}
\alias{process_candidate_sites}
\title{Obtains and filters candidate sites from FIMO result}
\usage{
process_candidate_sites(
  fimo_file,
  flank = 100,
  thresh_pValue = 1e-05,
  thresh_pwmscore = 0,
  blacklist_file = NULL,
  mapability_file = NULL,
  thresh_mapability = 0.8,
  bigWigAverageOverBed_path = "bigWigAverageOverBed"
)
}
\arguments{
\item{fimo_file}{\code{FIMO} result \sQuote{.txt} file}

\item{flank}{Flanking region (bp) around motif matches (default: 100)}

\item{thresh_pValue}{\code{FIMO} p-value threshold (default: 1e-5)}

\item{thresh_pwmscore}{\code{FIMO} PWM score threshold (default: 0)}

\item{blacklist_file}{Filename of the blacklist regions (default: NULL)}

\item{mapability_file}{Filename of the mapability reference file}

\item{thresh_mapability}{Mapability threshold (default: 0.8,
candidate sites need to be mapable at least 80\% positions).
This is only used when the \code{mapability_file} is available.}

\item{bigWigAverageOverBed_path}{Path to bigWigAverageOverBed executable
(only needed when filtering mapability).}
}
\value{
A data frame of processed candidate binding sites
passing the threshold filtering.
}
\description{
Gets candidate sites from FIMO motif matches and
add flanking regions, and filters the candidate sites by different thresholds,
and filters out sites in blacklist regions.
}
\examples{
\dontrun{
sites <- process_candidate_sites(fimo_file='fimo.txt',
                                 thresh_pValue=1e-5,
                                 blacklist_file='blacklist.hg38.bed.gz')
}
}
