% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_dnase_atac_data.R
\name{merge_normalize_bin_transform_counts}
\alias{merge_normalize_bin_transform_counts}
\title{Merges DNase or ATAC-seq counts from multiple replicates,
then normalizes, bin and transform the merged counts}
\usage{
merge_normalize_bin_transform_counts(
  counts_files,
  idxstats_files,
  ref_size = 1e+08,
  bin_method = c("M5", "M24", "M12", "M3", "M2", "M1"),
  transform = c("asinh", "log2", "sqrt", "none")
)
}
\arguments{
\item{counts_files}{DNase or ATAC-seq read counts matrix files.}

\item{idxstats_files}{The \code{idxstats} files generated by samtools.}

\item{ref_size}{Scale to DNase-seq or ATAC-seq reference library size.
(Default: 1e8 for DNase-seq and 5e7 for ATAC-seq).}

\item{bin_method}{\code{MILLIPEDE} binning scheme (default: \sQuote{M5}).}

\item{transform}{Type of transformation for DNase or ATAC counts.
Options: \sQuote{asinh}, \sQuote{log2}, \sQuote{sqrt}, \sQuote{none}.}
}
\value{
A data frame of merged, normalized, binned, and transformed counts.
}
\description{
Merges DNase-seq or ATAC-seq read counts from
multiple replicate samples,
normalizes the read counts by scaling to the reference library size,
then bins and transforms the merged counts.
}
