% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_reads.R
\name{index_fa}
\alias{index_fa}
\title{Indexes the FASTA file, and generates a \sQuote{chrom.sizes} file}
\usage{
index_fa(fa_file, chromsize_file = "chrom.sizes", outdir = dirname(fa_file))
}
\arguments{
\item{fa_file}{FASTA file of reference genome sequence.}

\item{chromsize_file}{Path of the output \sQuote{chrom.sizes} file.}

\item{outdir}{Output directory (default: saves to the directory of the FASTA file).}
}
\description{
Indexes the FASTA file, and generates a \sQuote{chrom.sizes} file
with chromosome numbers and the size of each chromosome.
}
\examples{
\dontrun{
index_fa('hg38.fa', chromsize_file='hg38.chrom.sizes')
}
}
