% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_reads.R
\name{get_total_reads}
\alias{get_total_reads}
\title{Gets total number of mapped reads from the \code{idxstats} file}
\usage{
get_total_reads(
  idxstats_file,
  select_chr = TRUE,
  chrs = paste0("chr", c(1:22))
)
}
\arguments{
\item{idxstats_file}{\code{idxstats} file.}

\item{select_chr}{Logical. If TRUE, counts reads in
chromosomes specified in \sQuote{chrs}.
Otherwise, uses all chromosomes in \code{idxstats_file}.}

\item{chrs}{Chromosomes to be included (default: chr1, ..., chr22).}
}
\value{
The total number of mapped reads.
}
\description{
Loads the \code{idxstats} file, and counts
the total number of mapped reads generated by \code{bam_sort_index_stats}.
}
\examples{
\dontrun{
total_mapped_reads <- get_total_reads('sample.bam.idxstats.txt')
}
}
