% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_dnase_atac_data.R
\name{get_sites_counts}
\alias{get_sites_counts}
\title{Extracts count matrices around candidate binding sites}
\usage{
get_sites_counts(
  sites,
  genomecount_dir,
  genomecount_name,
  tmpdir = genomecount_dir,
  bedGraphToBigWig_path = "bedGraphToBigWig",
  bwtool_path = "bwtool"
)
}
\arguments{
\item{sites}{A data frame containing the candidate sites.}

\item{genomecount_dir}{Directory for genome counts,
the same as \code{outdir} in \code{count_genome_cuts()}.}

\item{genomecount_name}{File prefix for genome counts,
the same as \code{outname} in \code{count_genome_cuts()}.}

\item{tmpdir}{Temporary directory to save intermediate files.}

\item{bedGraphToBigWig_path}{Path to UCSC \code{bedGraphToBigWig} executable.}

\item{bwtool_path}{Path to \code{bwtool} executable.}
}
\value{
A count matrix. The first half of the columns
are the read counts on the forward strand, and the second half of the
columns are the read counts on the reverse strand.
}
\description{
Extracts counts around candidate binding sites on both strands
from the genome counts data
(BigWig files generated using \code{count_genome_cuts()}).
It utilizes the \code{extract bed} function from the \code{bwtool} software
to extract the read counts,
then combines the counts into one matrix, with the first half of the columns
representing the read counts on the forward strand,
and the second half of the columns representing the read counts
on the reverse strand.
}
\examples{
\dontrun{
# Extracts ATAC-seq count matrices around candidate sites
count_matrix <- get_sites_counts(sites,
                                 genomecount_dir='processed_data',
                                 genomecount_name='K562.ATAC')
}
}
