% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postfit_coef_samples.R
\name{extract_TOP_coef_samples}
\alias{extract_TOP_coef_samples}
\title{Extracts regression coefficients from TOP posterior samples}
\usage{
extract_TOP_coef_samples(
  TOP_samples,
  tf_cell_combos,
  assembled_training_data,
  tf_name,
  cell_type,
  n_bins = 5,
  level = c("bottom", "middle", "top")
)
}
\arguments{
\item{TOP_samples}{TOP samples combined from all partitions using the
\code{combine_TOP_samples()} function.}

\item{tf_cell_combos}{A table with the indices and names of TF and cell type
combinations from the assembled training data. If missing,
will create the table using \code{assembled_training_data}.}

\item{assembled_training_data}{Assembled training data as in the
\code{assemble_training_data()} function.}

\item{tf_name}{TF name.}

\item{cell_type}{Cell type.}

\item{n_bins}{Number of DNase or ATAC bins in TOP model (default = 5).}

\item{level}{The level in the TOP model (options: \sQuote{bottom}, \sQuote{middle}, or \sQuote{top}).
\sQuote{bottom} level: TF- and cell-type- specific;
\sQuote{middle} level: TF-specific, cell-type generic;
\sQuote{top} level: TF-generic}
}
\value{
A data frame of posterior samples for TOP's regression coefficients.
}
\description{
Extracts regression coefficients from TOP posterior samples
}
\examples{
\dontrun{
TOP_coef_samples <- extract_TOP_coef_samples(TOP_samples,
                                             assembled_training_data = assembled_training_data)
# or
tf_cell_combos <- extract_tf_cell_combos(assembled_training_data)
TOP_coef_samples <- extract_TOP_coef_samples(TOP_samples,
                                             tf_cell_combos = tf_cell_combos)
}
}
