% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_chip_data.R
\name{count_normalize_chip}
\alias{count_normalize_chip}
\title{Counts and normalizes (and transforms) ChIP-seq read coverage}
\usage{
count_normalize_chip(
  sites,
  chip_bam_files,
  chip_idxstats_files,
  chrom_size_file,
  ref_size = 2e+07,
  transform = c("none", "asinh", "log2", "sqrt"),
  bedtools_path = "bedtools"
)
}
\arguments{
\item{sites}{A data frame containing the candidate sites.}

\item{chip_bam_files}{ChIP-seq BAM files (may include multiple replicates).}

\item{chip_idxstats_files}{ChIP-seq \code{idxstats} files
(may include multiple replicates).
(Default: uses the corresponding \code{.idxstats.txt} files in
the same directory of the BAM files).}

\item{chrom_size_file}{Chromosome size file.}

\item{ref_size}{Scales to ChIP-seq reference library size
(Default: 2e7)}

\item{transform}{Transformation for ChIP-seq read counts.
Options are \sQuote{none} (no transformation), \sQuote{asinh}, \sQuote{log2}, and \sQuote{'sqrt'}.}

\item{bedtools_path}{Path to \code{bedtools} executable.}
}
\value{
A data frame of candidate sites and normalized (and transformed)
ChIP-seq read counts around each candidate site.
}
\description{
Counts ChIP-seq read coverage for each BAM file
using the \code{coverage} function from \code{bedtools}.
Then normalizes the read counts
by scaling to the reference ChIP-seq library size,
and transforms the ChIP-seq read counts.
}
\examples{
\dontrun{
sites_chip <- count_normalize_chip(sites,
                                   chip_bam_files=c('ChIPseq.rep1.bam', 'ChIPseq.rep2.bam'),
                                   chrom_size_file='hg38.chrom.sizes',
                                   ref_size=2e7)
}
}
