% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_dnase_atac_data.R
\name{count_genome_cuts}
\alias{count_genome_cuts}
\title{Counts DNase-seq or ATAC-seq cuts along the genome}
\usage{
count_genome_cuts(
  bam_file,
  chrom_size_file,
  data_type = c("DNase", "ATAC"),
  shift_ATAC = TRUE,
  shift_ATAC_bases = c(4L, -4L),
  outdir = dirname(bam_file),
  outname,
  bedtools_path = "bedtools",
  bedGraphToBigWig_path = "bedGraphToBigWig"
)
}
\arguments{
\item{bam_file}{Sorted BAM file.}

\item{chrom_size_file}{Chromosome size file.}

\item{data_type}{Data type. Options: \sQuote{DNase} or \sQuote{ATAC}.}

\item{shift_ATAC}{Logical. When \code{shift_ATAC=TRUE} (and \code{data_type='ATAC'}),
shifts reads according to \code{shift_ATAC_bases}.}

\item{shift_ATAC_bases}{Number of bases to shift on + and - strands.
Default: shifts reads on + strand by 4 bp and reads on - strand by -4 bp.}

\item{outdir}{Output directory (default: use the directory of \code{bam_file}).}

\item{outname}{Output prefix (default: use the prefix of \code{bam_file}).}

\item{bedtools_path}{Path to \code{bedtools} executable.}

\item{bedGraphToBigWig_path}{Path to UCSC \code{bedGraphToBigWig} executable.}
}
\description{
Counts genomic cuts (5' end) from DNase-seq or
ATAC-seq BAM alignment files using \code{bedtools}
For ATAC-seq, when \code{shift_ATAC = TRUE}, shifts reads
so as to address offsets and align the signal across strands.
}
\examples{
\dontrun{
# ATAC-seq data
count_genome_cuts(bam_file='K562.ATAC.bam',
                  chrom_size_file='hg38.chrom.sizes',
                  data_type='ATAC',
                  shift_ATAC=TRUE,
                  outdir='processed_data',
                  outname='K562.ATAC')

# DNase-seq data
count_genome_cuts(bam_file='K562.DNase.bam',
                  chrom_size_file='hg38.chrom.sizes',
                  data_type='DNase',
                  outdir='processed_data',
                  outname='K562.DNase')
}
}
