% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_dnase_atac_data.R
\name{bin_transform_counts}
\alias{bin_transform_counts}
\title{Bins and transforms count matrix}
\usage{
bin_transform_counts(
  counts,
  bin_method = c("M5", "M24", "M12", "M3", "M2", "M1"),
  transform = c("asinh", "log2", "sqrt", "none")
)
}
\arguments{
\item{counts}{DNase or ATAC-seq read counts matrix}

\item{bin_method}{\code{MILLIPEDE} binning scheme (Default: \sQuote{M5}).}

\item{transform}{Type of transformation for DNase or ATAC counts.
Options: \sQuote{asinh}, \sQuote{log2}, \sQuote{sqrt}, \sQuote{none}.}
}
\value{
A data frame of binned and transformed counts.
}
\description{
Bins DNase or ATAC counts
using \code{MILLIPEDE} binning and then
take \sQuote{sqrt} or \sQuote{log2} transform
}
