% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_chip_data.R
\name{add_chip_signals_to_sites}
\alias{add_chip_signals_to_sites}
\title{Adds ChIP-seq signals to the candidate sites}
\usage{
add_chip_signals_to_sites(
  sites,
  chip_signal_file = NULL,
  chip_signal_sampleID = NULL,
  chip_signal_dir = "./",
  bigWigAverageOverBed_path = "bigWigAverageOverBed"
)
}
\arguments{
\item{sites}{A data frame containing the candidate sites}

\item{chip_signal_file}{ChIP-seq signal file (BigWig format).}

\item{chip_signal_sampleID}{ENCODE sample ID of ChIP-seq signals (BigWig format).}

\item{chip_signal_dir}{Directory to save the downloaded ChIP-seq signals.}

\item{bigWigAverageOverBed_path}{Path to \code{bigWigAverageOverBed} executable.}
}
\value{
A data frame of candidate sites and ChIP-seq signals.
}
\description{
Adds ChIP-seq signals to the candidate sites.
It uses ChIP-seq signals (in BigWig format) from \code{chip_signal_file}.
If \code{chip_peak_file} is not available, it will download the
ChIP-seq signals from ENCODE database (using
the sample ID provided in \code{chip_signal_sampleID},
and save to the directory \code{chip_signal_dir}).
}
\examples{
\dontrun{
sites_chip_signals - add_chip_signals_to_sites(sites, chip_signal_file='ChIPseq.signals.bigWig')
}
}
