% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_chip_data.R
\name{add_chip_peak_labels_to_sites}
\alias{add_chip_peak_labels_to_sites}
\title{Adds ChIP-seq peak labels to the candidate sites}
\usage{
add_chip_peak_labels_to_sites(
  sites,
  chip_peak_file = NULL,
  chip_peak_sampleID = NULL,
  chip_peak_dir = "./"
)
}
\arguments{
\item{sites}{A data frame containing the candidate sites}

\item{chip_peak_file}{ChIP-seq peak file (.bed.gz format)}

\item{chip_peak_sampleID}{ENCODE sample ID of ChIP-seq peaks (.bed.gz format)}

\item{chip_peak_dir}{Directory to save the downloaded ChIP-seq peaks}
}
\value{
A data frame of candidate sites and binary ChIP-seq peak labels
(bound: 1, unbound: 0).
}
\description{
Adds ChIP-seq peak labels to the candidate sites.
It uses ChIP-seq peaks from \code{chip_peak_file} if available.
If \code{chip_peak_file} is not available, it will download the
ChIP-seq peaks from ENCODE database (using
the sample ID provided in \code{chip_peak_sampleID},
and save to the directory \code{chip_peak_dir}).
}
\examples{
\dontrun{
sites_chip_labels <- add_chip_peak_labels_to_sites(sites, chip_peak_file='ChIPseq.peaks.bed.gz')
}
}
