## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = '#>'
)

## ----TOP-diagram, echo=FALSE, out.width = '90%'-------------------------------
knitr::include_graphics("../man/figures/schematic.png")

## ----load-TOP-package, eval=FALSE---------------------------------------------
#  library(TOP)

## ----assemble-TOP-training-data, eval=FALSE-----------------------------------
#  assembled_training_data <- assemble_training_data(tf_cell_table,
#                                                    training_chrs = paste0('chr', seq(1,21,2)),
#                                                    n_partitions = 10)

## ----fit-TOP-model, eval=FALSE------------------------------------------------
#  all_TOP_samples <- fit_TOP_M5_model(assembled_training_data,
#                                      logistic_model = FALSE,
#                                      transform = 'asinh',
#                                      n_iter = 5000,
#                                      n_burnin = 1000,
#                                      n_chains = 3,
#                                      n_thin = 2,
#                                      out_dir = 'TOP_fit')

## ----combine-TOP-samples, eval=FALSE------------------------------------------
#  TOP_samples <- combine_TOP_samples(all_TOP_samples)
#  dim(TOP_samples)

## ----extract-TOP-mean-coef, eval=FALSE----------------------------------------
#  TOP_mean_coef <- extract_TOP_mean_coef(TOP_samples,
#                           assembled_training_data = assembled_training_data)

## ----save-samples-coef, eval=FALSE--------------------------------------------
#  saveRDS(TOP_samples, 'TOP_fit/TOP_M5_combined_posterior_samples.rds')
#  saveRDS(TOP_mean_coef, 'TOP_fit/TOP_M5_posterior_mean_coef.rds')

