## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = '#>'
)

## ----load-TOP-package, eval=FALSE---------------------------------------------
#  library(TOP)

## ----assemble-TOP-logistic-training-data, eval=FALSE--------------------------
#  assembled_training_data <- assemble_training_data(tf_cell_table,
#                                                    logistic_model = TRUE, # use logistic model
#                                                    chip_colname = 'chip_label', # name of the column with ChIP labels in training data
#                                                    training_chrs = paste0('chr', seq(1,21,2)),
#                                                    n_partitions = 10)

## ----fit-TOP-model, eval=FALSE------------------------------------------------
#  all_TOP_samples <- fit_TOP_M5_model(assembled_training_data,
#                                      logistic_model = TRUE,
#                                      n_iter = 5000,
#                                      n_burnin = 2000,
#                                      n_chains = 3,
#                                      n_thin = 2,
#                                      out_dir = 'TOP_logistic_fit')

## ----combine-TOP-samples, eval=FALSE------------------------------------------
#  TOP_samples <- combine_TOP_samples(all_TOP_samples)
#  dim(TOP_samples)

## ----extract-TOP-mean-coef, eval=FALSE----------------------------------------
#  TOP_mean_coef <- extract_TOP_mean_coef(TOP_samples,
#                           assembled_training_data = assembled_training_data)

## ----save-samples-coef, eval=FALSE--------------------------------------------
#  saveRDS(TOP_samples, 'TOP_logistic_fit/TOP_logistic_M5_combined_posterior_samples.rds')
#  saveRDS(TOP_mean_coef, 'TOP_logistic_fit/TOP_logistic_M5_posterior_mean_coef.rds')

