import csv
import pdb
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.colors import ListedColormap
import seaborn as sns

tips = sns.load_dataset("tips")

# first 1500 calls from the test set are used for this analysis.
xhmmcalls = np.load('data_list_xhmm_preds_test_weightedcrossent_embeddingout.npy')[1500:]
cnvnatorcalls = np.load('data_list_cnvnator_preds_test_weightedcrossent_embeddingout.npy')[1500:]
chrs = np.load('data_list_chrs_test_weightedcrossent_embeddingout.npy')[1500:]
inds = np.load('data_list_indexes_test_weightedcrossent_embeddingout.npy')[1500:]
polished = np.load('polished_rev12.npy')[1500:]
gcs = np.load('data_list_gcs.npy')
mapp = np.load('data_list_mapp.npy')

corrected = []
correctedgcs = []
agreedgcs = []
for i in range(len(xhmmcalls)):
	if np.argmax(xhmmcalls[i]) == np.argmax(cnvnatorcalls[i]):
		corrected.append('DECoNT Agrees') # agrees
		agreedgcs.append(gcs[i])
	elif np.argmax(polished[i]) == np.argmax(cnvnatorcalls[i]):
		corrected.append('DECoNT Corrects') # correct
		correctedgcs.append(gcs[i])
	else: 
		corrected.append('DECoNT Agrees') # agrees
		agreedgcs.append(gcs[i])


corrected = np.asarray(corrected)

PROPS = {
    'boxprops':{'facecolor':'none', 'edgecolor':'black'},
    'medianprops':{'color':'black'},
    'whiskerprops':{'color':'black'},
    'capprops':{'color':'black'}
}
plt.rcParams.update({'font.size': 8})
plt.tight_layout()
palette = ['black','#D3D3D3']
pdb.set_trace()
fig, ax = plt.subplots()
sns.scatterplot(x=mapp, y=gcs, alpha=0.7, hue=corrected, palette=palette)
#sns.violinplot(x=corrected, y=gcs,alpha=0.2, color='white')
ax.set(ylim=(20, None))
plt.ylabel("GC Content", fontweight='normal', fontsize=10)
plt.xlabel("Mappability", fontweight='normal', fontsize=10)

plt.plot()


#ax.plot([0,1],[0,1], transform=ax.transAxes, color='black', linestyle='--', linewidth=0.4)

plt.show()



pdb.set_trace()
