
import numpy as np
import matplotlib.pyplot as plt


linspace = np.asarray([0.0, 0.01, 0.02, 0.03, 0.04, 0.05, 0.06, 0.07, 0.08, 0.09, 0.1,
       0.11, 0.12, 0.13, 0.14, 0.15, 0.16, 0.17, 0.18, 0.19, 0.2, 0.21,
       0.22, 0.23, 0.24, 0.25, 0.26, 0.27, 0.28, 0.29, 0.3, 0.31, 0.32,
       0.33, 0.34, 0.350, 0.36, 0.37, 0.38, 0.39, 0.4, 0.410, 0.42, 0.43,
       0.44, 0.45, 0.46, 0.470, 0.48, 0.49, 0.5, 0.51, 0.52, 0.53, 0.54,
       0.55, 0.56, 0.570, 0.58, 0.59, 0.6, 0.61, 0.62, 0.63, 0.64, 0.65,
       0.66, 0.67, 0.68, 0.690, 0.700, 0.71, 0.72, 0.73, 0.74, 0.75, 0.76,
       0.77, 0.78, 0.79, 0.8, 0.81, 0.820, 0.830, 0.84, 0.85, 0.86, 0.87,
       0.88, 0.89, 0.9, 0.91, 0.92, 0.93, 0.940, 0.950, 0.96, 0.97, 0.98,
       0.99])

unpdup_precs = [0.45433724592041225, 0.45433724592041225, 0.45433724592041225, 0.45433724592041225, 0.45433724592041225, 0.45433724592041225, 
0.45433724592041225, 0.45433724592041225, 0.45433724592041225, 0.45433724592041225, 0.45433724592041225, 0.45433724592041225, 0.45433724592041225, 
0.45433724592041225, 0.45433724592041225, 0.45433724592041225, 0.45433724592041225, 0.45433724592041225, 0.45433724592041225, 0.45433724592041225,
 0.45433724592041225, 0.45433724592041225, 0.45433724592041225, 0.45433724592041225, 0.45433724592041225, 0.45433724592041225, 0.45433724592041225, 
 0.45433724592041225, 0.45433724592041225, 0.45433724592041225, 0.45433724592041225, 0.45433724592041225, 0.45433724592041225, 0.45433724592041225, 
 0.45446735395189003, 0.45431108564881123, 0.4544412607449857, 0.4544412607449857, 0.4544412607449857, 0.45428489538549727, 0.454519368723099, 0.454519368723099,
  0.45472837022132795, 0.4543884892086331, 0.45407428735963146, 0.4545716758004038, 0.45496535796766746, 0.45522819179664936, 0.45576251455180444, 0.4559297218155198,
   0.4577173270254287, 0.45637785800240677, 0.4603978300180832, 0.46397909667786486, 0.4662878787878788, 0.4659969088098918, 0.4669016842929886, 0.46823811426288453, 
   0.4689403166869671, 0.47172926124638875, 0.47186327636515213, 0.4726810673443456, 0.4731182795698925, 0.4755458515283843, 0.4790739091718611, 0.4807430901676484,
    0.48228255867464337, 0.4827264239028945, 0.48467703913248467, 0.48687350835322196, 0.49053857350800584, 0.49061264822134387, 0.49247743229689067, 0.49365804160324706, 
    0.49742002063983487, 0.49580712788259956, 0.4965443912812334, 0.49836601307189543, 0.503337041156841, 0.504524886877828, 0.5075231481481481, 0.5088862559241706, 0.5141104294478528,
     0.5181476846057572, 0.5196647324306899, 0.5235880398671097, 0.5309065934065934, 0.5349823321554771, 0.5328947368421053, 0.5343915343915344, 0.5404556166535742, 0.542997542997543, 
     0.5512820512820513, 0.5607560756075608, 0.5700575815738963, 0.58098223615465, 0.597254004576659, 0.6266318537859008, 0.6521739130434783, 0.7088888888888889]
dup_precs = [0.6451481932602517, 0.6451481932602517, 0.6451481932602517, 0.6451481932602517, 0.6451481932602517, 0.6451481932602517, 0.6451481932602517, 0.6451481932602517, 0.6451481932602517, 0.6451481932602517, 0.6451481932602517, 0.6451481932602517, 0.6451481932602517, 0.6451481932602517, 0.6451481932602517, 0.6451481932602517, 0.6451481932602517, 0.6451481932602517, 0.6451481932602517, 0.6451481932602517, 0.6451481932602517, 0.6451481932602517, 0.6451481932602517, 0.6451481932602517, 0.6451481932602517, 0.6451481932602517, 0.6451481932602517, 0.6451481932602517, 0.6451481932602517, 0.6451481932602517, 0.6451481932602517, 0.6451481932602517, 0.6451481932602517, 0.6451481932602517, 0.6451481932602517, 0.6454102355808286, 0.6457909719398129, 0.646053702196908, 0.6465798045602605, 0.6468431771894094, 0.6481632653061224, 0.648019599836668, 0.6479967293540474, 0.6476853748463745, 0.64766201804758, 0.6492168178070898, 0.6493399339933993, 0.65, 0.6510178645616951, 0.651901379022148, 0.6544458491361146, 0.6555412922550278, 0.7210732252655114, 0.735191637630662, 0.7394366197183099, 0.7443249701314217, 0.7484848484848485, 0.7547869054972205, 0.7556390977443609, 0.7612985359643539, 0.7619047619047619, 0.7635532331809275, 0.7692307692307693, 0.7714477211796247, 0.7748299319727892, 0.7763248451479697, 0.7771587743732591, 0.7813163481953291, 0.7847919655667145, 0.7893972403776325, 0.793662490788504, 0.7984962406015037, 0.8016781083142639, 0.8013803680981595, 0.8060747663551402, 0.8042620363062352, 0.8073836276083467, 0.8123456790123457, 0.8211586901763224, 0.8222789115646258, 0.8271391529818496, 0.8273127753303965, 0.8391224862888482, 0.8437209302325581, 0.8494726749760306, 0.8544739429695182, 0.8618951612903226, 0.8677685950413223, 0.8661670235546038, 0.8708609271523179, 0.8853211009174312, 0.8923444976076556, 0.895320197044335, 0.8991060025542784, 0.9044414535666218, 0.9163059163059163, 0.9198767334360555, 0.9335604770017035, 0.9354207436399217, 0.9523809523809523]

unpdel_precs =[0.4144953578915843, 0.4144953578915843, 0.4144953578915843, 0.4144953578915843, 0.4144953578915843, 0.4144953578915843, 0.4144953578915843, 0.4144953578915843, 0.4144953578915843, 0.4144953578915843, 0.4144953578915843, 0.4144953578915843, 0.4144953578915843, 0.4144953578915843, 0.4144953578915843, 0.4144953578915843, 0.4144953578915843, 0.4144953578915843, 0.4144953578915843, 0.4144953578915843, 0.4144953578915843, 0.4144953578915843, 0.4144953578915843, 0.4144953578915843, 0.4144953578915843, 0.4144953578915843, 0.4144953578915843, 0.4144953578915843, 0.4144953578915843, 0.4144953578915843, 0.4144953578915843, 0.4144953578915843, 0.4144953578915843, 0.4144953578915843, 0.4144953578915843, 0.41444411147737487, 0.41494149414941495, 0.41556490384615385, 0.4550581600281988, 0.4544487770294222, 0.45451302176239744, 0.45487106017191975, 0.4564748201438849, 0.45717383447777377, 0.45778748180494905, 0.45961820851688695, 0.46014760147601474, 0.46156702562198293, 0.4641919760029996, 0.4665406427221172, 0.4685474647350362, 0.4727483571704677, 0.4772549019607843, 0.47925721058870013, 0.4818363273453094, 0.48525252525252527, 0.4888705688375927, 0.4899665551839465, 0.4946785866326096, 0.4987068965517241, 0.5028421512898994, 0.5084219858156028, 0.5105713000449843, 0.5136363636363637, 0.5180221811460258, 0.5185533114138093, 0.5193317422434367, 0.5223300970873787, 0.5262116716122651, 0.5272909364046069, 0.5311077389984825, 0.5370751802265705, 0.5429769392033543, 0.5468085106382978, 0.5557974959172564, 0.561218836565097, 0.5686053077357425, 0.5746397694524495, 0.5805134189031506, 0.5850622406639004, 0.5905797101449275, 0.5950769230769231, 0.5976145637162587, 0.6006451612903225, 0.603414313854235, 0.6103983794733289, 0.6127922971114168, 0.6177304964539007, 0.6196769456681351, 0.6271829916476841, 0.6404494382022472, 0.6479463537300922, 0.6540158870255958, 0.6625708884688091, 0.676923076923077, 0.6923076923076923, 0.7054545454545454, 0.7248603351955307, 0.7467948717948718, 0.7878103837471784]
del_precs = [0.7046204620462047, 0.7046204620462047, 0.7046204620462047, 0.7046204620462047, 0.7046204620462047, 0.7046204620462047, 0.7046204620462047, 0.7046204620462047, 0.7046204620462047, 0.7046204620462047, 0.7046204620462047, 0.7046204620462047, 0.7046204620462047, 0.7046204620462047, 0.7046204620462047, 0.7046204620462047, 0.7046204620462047, 0.7046204620462047, 0.7046204620462047, 0.7046204620462047, 0.7046204620462047, 0.7046204620462047, 0.7046204620462047, 0.7046204620462047, 0.7046204620462047, 0.7046204620462047, 0.7046204620462047, 0.7046204620462047, 0.7046204620462047, 0.7046204620462047, 0.7046204620462047, 0.7046204620462047, 0.7046204620462047, 0.7046204620462047, 0.7046204620462047, 0.7050082553659879, 0.7050082553659879, 0.7050082553659879, 0.7050082553659879, 0.7048458149779736, 0.7064017660044151, 0.7062396466040861, 0.707641196013289, 0.7084952803997779, 0.7084028937117418, 0.7099832682654769, 0.7112479015109121, 0.7118834080717489, 0.7142051860202931, 0.7175269427112876, 0.719088319088319, 0.7256484149855907, 0.7295414973882762, 0.7309260337798485, 0.7353286384976526, 0.7383066903493192, 0.7401197604790419, 0.7415458937198067, 0.7463235294117647, 0.749384236453202, 0.7535780958307405, 0.7576706324358171, 0.7610899873257287, 0.7654952076677316, 0.7688831504196255, 0.7704918032786885, 0.7736351531291611, 0.778600269179004, 0.7849315068493151, 0.7868512110726643, 0.7883414295628036, 0.7922807017543859, 0.7953257790368272, 0.7954383464005702, 0.8020231213872833, 0.8039358600583091, 0.8069016152716594, 0.8139013452914798, 0.8183873398643556, 0.8235294117647058, 0.8282828282828283, 0.8294025157232704, 0.830806065442937, 0.8338788870703764, 0.8362427265170407, 0.8450342465753424, 0.8493870402802102, 0.8536804308797128, 0.8530499075785583, 0.8582230623818525, 0.8668639053254438, 0.8791322314049587, 0.8874316939890711, 0.895906432748538, 0.9080604534005038, 0.9159891598915989, 0.9238653001464129, 0.9284525790349417, 0.939622641509434, 0.9494949494949495]

unpoverall_precs = [0.43486533957845436, 0.43486533957845436, 0.43486533957845436, 0.43486533957845436, 0.43486533957845436, 0.43486533957845436, 0.43486533957845436, 0.43486533957845436, 0.43486533957845436, 0.43486533957845436, 0.43486533957845436, 0.43486533957845436, 0.43486533957845436, 0.43486533957845436, 0.43486533957845436, 0.43486533957845436, 0.43486533957845436, 0.43486533957845436, 0.43486533957845436, 0.43486533957845436, 0.43486533957845436, 0.43486533957845436, 0.43486533957845436, 0.43486533957845436, 0.43486533957845436, 0.43486533957845436, 0.43486533957845436, 0.43486533957845436, 0.43486533957845436, 0.43486533957845436, 0.43486533957845436, 0.43486533957845436, 0.43486533957845436, 0.43486533957845436, 0.43492900014639146, 0.4348271821909783, 0.43514583027993553, 0.4354649457318862, 0.4547178757705074, 0.4543581616481775, 0.45451653944020354, 0.45467580054166, 0.4555040741332481, 0.4556231976930471, 0.4557145153512297, 0.45679211759005006, 0.45724003887269193, 0.4580016246953696, 0.4594461740127806, 0.46056105610561054, 0.46244796003330557, 0.46354254779225174, 0.4684854186265287, 0.47140115163147794, 0.4738581146744412, 0.47540983606557374, 0.47760594496886927, 0.478855975485189, 0.4815045719035744, 0.4849251528568417, 0.48698250106700813, 0.49014511587611004, 0.49142480211081796, 0.4942093541202673, 0.4981859410430839, 0.4993081180811808, 0.5004686035613871, 0.5021418372203712, 0.5049481052377505, 0.5065982404692082, 0.5104011887072808, 0.513363590519415, 0.5171706817016914, 0.5196052973253701, 0.5258278145695364, 0.5276057096687314, 0.5314895947426068, 0.5354242509101093, 0.541002277904328, 0.543849493487699, 0.5481678486997635, 0.5511620887413221, 0.5553831833695315, 0.5587674714104193, 0.5611581001951854, 0.5666443402545212, 0.5718213058419244, 0.5762831858407079, 0.5761904761904761, 0.5806818181818182, 0.5899166335847559, 0.5948632974316487, 0.601823708206687, 0.6104195481788843, 0.6217154189390184, 0.6348435814455232, 0.6497939964685109, 0.6740890688259109, 0.6987381703470031, 0.748040313549832]
overall_precs = [0.6704041111889746, 0.6704041111889746, 0.6704041111889746, 0.6704041111889746, 0.6704041111889746, 0.6704041111889746, 0.6704041111889746, 0.6704041111889746, 0.6704041111889746, 0.6704041111889746, 0.6704041111889746, 0.6704041111889746, 0.6704041111889746, 0.6704041111889746, 0.6704041111889746, 0.6704041111889746, 0.6704041111889746, 0.6704041111889746, 0.6704041111889746, 0.6704041111889746, 0.6704041111889746, 0.6704041111889746, 0.6704041111889746, 0.6704041111889746, 0.6704041111889746, 0.6704041111889746, 0.6704041111889746, 0.6704041111889746, 0.6704041111889746, 0.6704041111889746, 0.6704041111889746, 0.6704041111889746, 0.6704041111889746, 0.6704041111889746, 0.6704041111889746, 0.6707174573498481, 0.6709541627689429, 0.6711111111111111, 0.6714252281769248, 0.6715055022243035, 0.6729235100891601, 0.6727699530516432, 0.6733301975540922, 0.6735030645921735, 0.6734356552538371, 0.6750414790234652, 0.6756114937069579, 0.6762607040913415, 0.6778282707486247, 0.6797401347449471, 0.6819282945736435, 0.6854125736738703, 0.7252277904328018, 0.7330619366094795, 0.7373826291079812, 0.7413024085637824, 0.744277108433735, 0.7480916030534351, 0.7509293680297398, 0.7552425665101722, 0.7576716229041442, 0.7605498721227621, 0.7650680492546986, 0.7684003925417076, 0.7717787346803577, 0.7733378106111484, 0.775357385976855, 0.7799241117626767, 0.7848633496846531, 0.7880935506732814, 0.7909220872051466, 0.7952813067150635, 0.7983841351450606, 0.7983007018840045, 0.8039730134932533, 0.804092459264873, 0.8071319018404908, 0.8131609870740305, 0.8196981731532963, 0.8229376257545271, 0.8277414075286416, 0.8284171167428334, 0.8346825734980826, 0.8384849804092295, 0.8423864648263579, 0.8494279176201373, 0.8552014995313965, 0.8602305475504323, 0.8591269841269841, 0.8640529531568228, 0.8753976670201484, 0.8852549889135255, 0.8911407064273307, 0.8974358974358975, 0.9063109954456734, 0.9161425576519916, 0.9219219219219219, 0.930976430976431, 0.9375600384245918, 0.9509043927648578]



sample_count = [6832, 6832, 6832, 6832, 6832, 6832, 6832, 6832, 6832, 6832, 6832, 6832, 6832, 6832, 6832, 6832, 6832, 6832, 6832, 6832, 6832, 6832, 6832, 6832, 6832, 6832, 6832, 6832, 6832, 6832, 6832, 6832, 6832, 6832, 6831, 6828, 6823, 6818, 6327, 6310, 6288, 6277, 6259, 6242, 6221, 6191, 6174, 6155, 6103, 6060, 6005, 5911, 5315, 5210, 5145, 5063, 4979, 4895, 4812, 4743, 4686, 4617, 4548, 4490, 4410, 4336, 4268, 4202, 4143, 4092, 4038, 3966, 3902, 3851, 3775, 3713, 3652, 3571, 3512, 3455, 3384, 3313, 3223, 3148, 3074, 2986, 2910, 2825, 2730, 2640, 2519, 2414, 2303, 2169, 2017, 1854, 1699, 1482, 1268, 893]

plt.rcParams.update({'font.size': 11})


fig, axs = plt.subplots(2, 2,figsize=(8,8))




axs[0,0].plot(linspace, np.asarray(unpdup_precs), label='XHMM')
axs[0,0].plot(linspace, np.asarray(dup_precs), label='DECoNT')
axs[0,0].set_title('Duplication Precision',fontsize=11)
axs[0,0].set_xlabel('Confidence Threshold',fontsize=11)
axs[0,0].set_ylabel('Precision',fontsize=11)
axs[0,0].set_xticks(np.linspace(0,1,11))
axs[0,0].set_yticks(np.linspace(0.4,1,15))
axs[0,0].yaxis.set_major_formatter('{x:.2f}')
axs[0,0].legend()



axs[0,1].plot(linspace, np.asarray(unpdel_precs), label='XHMM')
axs[0,1].plot(linspace, np.asarray(del_precs), label='DECoNT')
axs[0,1].set_title('Deletion Precision',fontsize=11)
axs[0,1].set_xlabel('Confidence Threshold',fontsize=11)
axs[0,1].set_ylabel('Precision',fontsize=11)
axs[0,1].set_xticks(np.linspace(0,1,11))
axs[0,1].set_yticks(np.linspace(0.36,1,15))
axs[0,1].yaxis.set_major_formatter('{x:.2f}')

axs[0,1].legend()

axs[1,0].plot(linspace, np.asarray(unpoverall_precs), label='XHMM')
axs[1,0].plot(linspace, np.asarray(overall_precs), label='DECoNT')
axs[1,0].set_title('Overall Precision',fontsize=11)
axs[1,0].set_xlabel('Confidence Threshold',fontsize=11)
axs[1,0].set_ylabel('Precision',fontsize=11)
axs[1,0].set_xticks(np.linspace(0,1,11))
axs[1,0].set_yticks(np.linspace(0.4,1,15))
axs[1,0].yaxis.set_major_formatter('{x:.2f}')

axs[1,0].legend()

axs[1,1].plot(linspace, np.asarray(sample_count), label='sample count')
axs[1,1].set_title('Sample Count in the Test Set',fontsize=11)
axs[1,1].set_xlabel('Confidence Threshold',fontsize=11)
axs[1,1].set_ylabel('Count',fontsize=11)
axs[1,1].set_xticks(np.linspace(0,1,11))
axs[1,1].set_yticks(np.linspace(0,7000,15))
#axs[1,1].yaxis.set_major_formatter('{x}')

axs[1,1].legend()

plt.tight_layout()
plt.show()
plt.savefig('precs_plus_sampcount_fontsize14.pdf')
plt.savefig('precs_plus_sampcount_fontsize14.png', dpi=200)
plt.savefig('precs_plus_sampcount_fontsize14.jpeg', dpi=200)


# # DEL precision figure

# plt.plot(linspace, unpdel_precs, label='XHMM')
# plt.plot(linspace, del_precs, label='DECoNT')


# plt.title('Deletion Precision')
# plt.xlabel('confidence threshold')
# plt.ylabel('precision')
# plt.legend()
# plt.savefig('delprecs_confidence.pdf')
# plt.close()

# # OVERALL precision figure

# plt.plot(linspace.tolist(), unpoverall_precs, label='XHMM')
# plt.plot(linspace.tolist(), overall_precs, label='DECoNT')


# plt.title('Overall Precision')
# plt.xlabel('confidence threshold')
# plt.ylabel('precision')
# plt.legend()
# plt.savefig('overallprecs_confidence.pdf')
# plt.close()

# # sample count  figure

# plt.plot(linspace.tolist(), sample_count, label='sample count')

# plt.title('Number of test samples')
# plt.xlabel('confidence threshold')
# plt.ylabel('test samples')
# plt.legend()
# plt.savefig('numtestsamples_confidence.pdf')
# plt.close()
