#import os
#os.environ["CUDA_DEVICE_ORDER"] = "PCI_BUS_ID"   # see issue #152
#os.environ["CUDA_VISIBLE_DEVICES"] = "6"
import numpy as np
import warnings
warnings.filterwarnings('ignore')
import pandas as pd
import os
import pdb
import time
import keras.backend as K
from tqdm import tqdm
import keras_metrics
from keras_metrics import categorical_precision, categorical_recall
from tensorflow.keras.layers import Input
from tensorflow.keras.preprocessing import sequence
from tensorflow.keras.layers import LSTM, Dense, Masking, Concatenate, concatenate, Bidirectional, BatchNormalization, Dropout
from tensorflow.keras.utils import to_categorical
from sklearn.preprocessing import LabelEncoder
from tensorflow.keras.models import Sequential, Model, load_model
from tensorflow.keras.utils import multi_gpu_model
import matplotlib.pyplot as plt
import seaborn as sns

os.environ["CUDA_DEVICE_ORDER"] = "PCI_BUS_ID"
os.environ["CUDA_VISIBLE_DEVICES"]= ""

freec_polisher = load_model("../DECoNTfreec_batchnorm_bilstm128_batchnorm_dense100_dense1_bs256_padding-1_60epochs_traintestsplitted_mae.h5")


data_list_readdepths = np.load('./data_list_readdepths_test.npy')
data_list_indexes = []
data_list_canavar_preds = np.load('./data_list_canavar_preds_test.npy')
data_list_freec_preds = np.load('./data_list_freec_preds_test.npy')


polished_preds = freec_polisher.predict([data_list_freec_preds, data_list_readdepths], verbose=1)
polished_preds = polished_preds.reshape(-1,)

ae_freec = np.abs(data_list_canavar_preds.astype(np.float64) - data_list_freec_preds.astype(np.float64))
ae_decont = np.abs(data_list_canavar_preds.astype(np.float64) - polished_preds.astype(np.float64))
dif = ae_freec - ae_decont
sdif = -np.sort(-dif)

data = [data_list_freec_preds.astype(np.float64), polished_preds, data_list_canavar_preds.astype(np.float64)]
colors = [(0,0,0),(0,0,0),(0,0,0)]
fig, ax = plt.subplots()
box_dict = sns.boxplot(data=data, showfliers=False, orient='v', color='black')
plt.xticks([0, 1, 2], ['Control-FREEC', 'DECoNT','Ground Truth'])
box_dict.artists[0].set_facecolor((0.9568,0.2705,0.6274))
box_dict.artists[1].set_facecolor((0.7843,0.8313,0.4235))
box_dict.artists[2].set_facecolor((0.1098,0.2078,0.3019))

plt.ylabel("Exact Copy Number")
plt.savefig('result.png')

plt.show() 



#somecomment
