"""
minjiezhang123@gmail.com    2020-12-16      python 3
This script is used to plot the overlapping two arms for homo.sam.

"""


#1. input and output setup
################################################################################
################################################################################
#this section sets up the input and output
import sys, argparse, numpy, os, re, itertools, random, math
from datetime import datetime
import seaborn as sns
import matplotlib.pyplot as plt
from math import floor, ceil
from itertools import product
import matplotlib as mpl

if len(sys.argv) < 3:
    print("Usage:               python  plot_heatmap_for_homodimer.py  homo_sam  target_pos  winbin  interval_gridline  overlap_cutoff  outprefix")
    print("homo_sam:            homo sam (overlapped chimeras) file generated by gaptypes.py")
    print("target_pos:          target position, eg: chr1:1233-1347:+   ")
    print("winbin:              window bin used to plot heatmap         ")
    print("interval_gridline:   the interval length for gridlines       ")
    print("overlap_cutoff:      cutoff value for overlap length, eg: 3  ")
    print("outputprefix                                                 ")
    sys.exit()

inputsam = open(sys.argv[1],'r')
target_pos = sys.argv[2]
winbin = int(sys.argv[3])
interval = int(sys.argv[4])
overlap_cutoff=int(sys.argv[5])
outprefix = sys.argv[6]
################################################################################


#2. subfunctions
################################################################################
def timenow(): return str(datetime.now())[:-7]

def mergeCIGAR(CIGAR): 
    #merge all operations that consume the reference, i.e. MI=X
    #example: 1S2M3N4M5I6M7S -> 1S2M3N10M7S 
    ops = re.findall('\d+[MNISH=X]', CIGAR) #all that consume query
    newops = [ops[0]]
    for op in ops[1:]: #concatenate all internal ops that consume query [MIS=X
        if op[-1] not in "I=X":
            if newops[-1][-1]=="M" and op[-1]=="M":
                newops[-1] = str(int(newops[-1][:-1])+int(op[:-1]))+"M"
            else: newops.append(op)
    newCIGAR = ("".join(str(i) for i in newops))
    return newCIGAR

# get homo chimeras segs
def get_homo_segs(line): #turn an alignment into segs [(RNAME, STRAND L, R), ...]
    # A00208:104:HJCGWDRXX:1:2128:6696:28557-HEK293toRNA      2064    chr1    1109945 255     24M2I1D2I1D33M  *       0       0\
    # GGCCGTGAAATGGGGGGTCAGTTAGTGTGCCTGGCAGCGAGCCATCACTGTTTCCATACCG   :FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF:FFFFFFFFFFFFFFFFFFF:FFF \
    # NH:i:1  HI:i:1  AS:i:25 nM:i:0  NM:i:0  MD:Z:26 jM:B:c,-1jI:B:i,-1       ch:A:1  SA:Z:chr1,1109969,-,21S35M27S,255,0;
    align = line.rstrip('\n').split('\t')
    readID, CHR, POS, CIGAR = align[0], align[2], int(align[3]), align[5]
    STRAND = '-' if '{0:012b}'.format(int(align[1]))[-5] == '1' else '+'
    seglens = [int(i[:-1]) for i in re.findall('[0-9]+M', CIGAR)] #seg lengths
    overlap = len(re.findall('2I1D', CIGAR))
    seg1 = [CHR, POS, POS+seglens[0]+overlap-1, STRAND, seglens[0]+overlap]
    seg2 = [CHR, POS+seglens[0], POS+seglens[0]+seglens[1]+overlap-1, STRAND, seglens[1]+overlap]
    overlapseg = [CHR, POS+seglens[0], POS+seglens[0]+overlap-1, STRAND, overlap]
    segs = [seg1, seg2, overlapseg]
    return readID,segs

# get gap1 segs
def get_gap1_segs(line): #turn an alignment into segs [(RNAME, STRAND L, R), ...]
    align = line.split(); segs = []; mingap_len = 0
    CHR, POS, CIGAR = align[2], int(align[3]), align[5]
    STRAND = '-' if '{0:012b}'.format(int(align[1]))[-5] == '1' else '+'
    seglens = [int(i[:-1]) for i in re.findall('[0-9]+M', mergeCIGAR(CIGAR))] #seg lengths
    gaplens = [int(i[:-1]) for i in re.findall('[0-9]+N', mergeCIGAR(CIGAR))] #gap lengths
    Ns =[i.rstrip('0123456789') for i in mergeCIGAR(CIGAR).split('M')]
    rx = [] #reference consumed: MD=X
    for N in Ns:
        rx.append(sum([int(i[:-1]) for i in re.findall('[0-9]+[ND=X]', N)]))
    for i in range(len(seglens)): #combine ref and segment lengths to make the junctions
        l, r = POS+sum(rx[:i+1])+sum(seglens[:i]), POS+sum(rx[:i+1])+sum(seglens[:i+1])-1
        if (CHR, int(l), int(r), STRAND) not in segs: segs.append((CHR, int(l), int(r), STRAND))
        segs.sort()
    #print(segs[align[0]])
    mingap_len = min(gaplens)
    return mingap_len,segs

# a: [chr1, 1233, 1347, +]
# b: [chr1, 1230, 1377, +]
def getOverlap(a, b):
    seganno = "False"
    if a[0]==b[0] and a[3]==b[3]:
        overlap = int(min(int(a[2]),int(b[2]))) - int(max(int(a[1]),int(b[1])))
        if overlap >1 and overlap >= readslen: seganno = "Ture"
    return seganno

## test whether bed1 was included by bed2:
def bedinregions(bed, target_region):
    # bed = ['hs45S', '3998', '4012', '+']
    # regions = [['hs45S', '3654', '5523', '+'], ['hs45S', '6600', '6757', '+'], ['hs45S', '7924', '12994', '+']]
    bedanno = 'False'
    if str(bed[0]) == str(target_region[0]) and str(bed[3]) == str(target_region[3]):
        if int(bed[1]) >= int(target_region[1]) and int(bed[2]) <= int(target_region[2]):
            bedanno = 'True'
    return bedanno

# get noBP within winbin:
# get_interval(6,12,4,13,'+',5)
# output: [0, 1]
def get_interval(seg_start, seg_end, gene_start, gene_end, gene_strand, winbin):
    start = 1; end = 0; interval = []
    if int(gene_start) <= int(seg_start): start = int(seg_start)-int(gene_start)+1
    if int(seg_end) <= int(gene_end): end = int(seg_end)-int(gene_start)+1
    else: end = int(gene_end)-int(gene_start)+1
    for i in range(floor(start/winbin), ceil(end/winbin), 1):
        if gene_strand == '+':  interval.append(i)
        if gene_strand == '-':  interval.append(ceil((int(gene_end)-int(gene_start)+1)/winbin-1)-i)
    return sorted(interval)

# Python program to illustrate the intersection
# of two lists using set() method
def intersection(lst1, lst2):
    return list(set(lst1) & set(lst2))

## Plot heatmap:
cdict = {'red':   [(0.0,  1.0, 1.0),(0.4,  0.6, 0.6),(0.6,  0.4, 0.4),(1.0,  0.0, 0.0)],
         'green': [(0.0,  1.0, 1.0),(0.4,  0.6, 0.6),(0.6,  0.4, 0.4),(1.0,  0.0, 0.0)],
         'blue':  [(0.0,  1.0, 1.0),(0.4,  0.6, 0.6),(0.6,  0.4, 0.4),(1.0,  0.0, 0.0)]}
cmp1 = mpl.colors.LinearSegmentedColormap('name',cdict)

def plot_heatmap(heatmap_matrix, start, end, interval, winbin, outprefix):
    axes = plt.subplot(1,1,1)
    max_chimeras = int(heatmap_matrix.max())
    sns.heatmap(heatmap_matrix,cmap=cmp1, vmin=0, vmax=max_chimeras, zorder=10)
    for x in range(0, ceil(((int(end)-int(start)+1)/winbin)+(interval/winbin)), int(interval/winbin)): plt.vlines(x, 0, ceil(int(end)-int(start)+1)/winbin, color = "silver", linestyles = "solid", linewidth=1, zorder=10)
    for x in range(0, ceil(((int(end)-int(start)+1)/winbin)+(interval/winbin)), int(interval/winbin)): plt.hlines(x, 0, ceil(int(end)-int(start)+1)/winbin, color = "silver", linestyles = "solid", linewidth=1, zorder=10)
    #plt.plot([0, ceil((int(end)-int(start)+1)/winbin)],[0, ceil((int(end)-int(start)+1)/winbin)], linewidth=2, color = 'silver', zorder=15)
    sns.despine(top=False, right=False, left=False, bottom=False)
    axes.xaxis.set_ticklabels([])
    axes.yaxis.set_ticklabels([])
    plt.xticks([])
    plt.yticks([])
    plt.savefig(outprefix+".pdf")
    plt.show()
    return
################################################################################


#3 start processing the homo sam file.
################################################################################
print(timenow()+" Process homo chimeric sam file...")
target_region = [target_pos.split(':')[0],target_pos.split(':')[1].split('-')[0],target_pos.split(':')[1].split('-')[1],target_pos.split(':')[-1]]
target_reads = {} #{readID: [seg1, seg2, overlapseg]}

for line in inputsam:
    if line[0]=='@': continue;
    readID,segs = get_homo_segs(line)
    # get the target regions info
    if bedinregions([segs[0][0],segs[0][1],segs[1][2],segs[0][3]], target_region) == 'True':
        if segs[2][4] >= overlap_cutoff:
            # store targetregion info
            target_reads[readID] = segs
inputsam.close()
################################################################################


#4 plot heatmap plots
################################################################################
print(timenow()+" Plot heatmap...")
target_len = int(target_region[2]) - int(target_region[1]) + 1
col_num = ceil(target_len/winbin); row_num = ceil(target_len/winbin)
heatmap_matrix = numpy.zeros((row_num,col_num));            heatmap_matrix_log = numpy.zeros((row_num,col_num))

# get the heatmap_matrix coverage
for readID in target_reads:
    #print(target_reads[readID])
    seg_l, seg_r, seg_over = target_reads[readID]
    interval_l = get_interval(seg_l[1], seg_l[2], target_region[1], target_region[2], target_region[3], winbin)
    interval_r = get_interval(seg_r[1], seg_r[2], target_region[1], target_region[2], target_region[3], winbin)
    for i in interval_r:
        for j in interval_l:
            heatmap_matrix[i,j] += 1;
            #X: left arm; Y: right arm
    for i in intersection(interval_l, interval_r):
        for j in intersection(interval_l, interval_r):
            heatmap_matrix[i,j] += 1

                   
# normalize matrix
for i in range(0, row_num, 1):
    for j in range(0, col_num, 1):
        if heatmap_matrix[i,j]==0:  heatmap_matrix_log[i,j]=0
        else: heatmap_matrix_log[i,j] = math.log(heatmap_matrix[i,j],2)

        
# plot heatmap
plot_heatmap(heatmap_matrix_log, target_region[1], target_region[2], interval, winbin, outprefix)