"""
minjiezhang123@gmail.com    2021-07-16      python 3
This script is used to calculate the distance between two arms of gap1/homo/trans sam;
or calculate the minimum distance among multiple arms of gapm.sam.

"""


#1. input and output setup
################################################################################
################################################################################
#this section sets up the input and output
import sys, argparse, numpy, os, re, itertools, random
from datetime import datetime
from math import floor, ceil
from itertools import product
from itertools import combinations

if len(sys.argv) < 4:
    print("Usage:           python get_arms_distance.py  inputsam  samtype  interval  outputfile")
    print("inputsam:        inputsam file generated by gaptypes.py              ")
    print("samtype:         eg: gap1, gapm, trans, homo                         ")
    print("interval:        interval length used to call the distance among arms")
    print("outputfile                                                           ")
    sys.exit()

inputsam = open(sys.argv[1],'r')
samtype = sys.argv[2]
interval = int(sys.argv[3])
output = open(sys.argv[4],'w')
################################################################################


#2. subfunctions
################################################################################
def timenow(): return str(datetime.now())[:-7]

def mergeCIGAR(CIGAR): 
    #merge all operations that consume the reference, i.e. MI=X
    #example: 1S2M3N4M5I6M7S -> 1S2M3N10M7S 
    ops = re.findall('\d+[MNISH=X]', CIGAR) #all that consume query
    newops = [ops[0]]
    for op in ops[1:]: #concatenate all internal ops that consume query [MIS=X
        if op[-1] not in "I=X":
            if newops[-1][-1]=="M" and op[-1]=="M":
                newops[-1] = str(int(newops[-1][:-1])+int(op[:-1]))+"M"
            else: newops.append(op)
    newCIGAR = ("".join(str(i) for i in newops))
    return newCIGAR

# get homo chimeras segs
def get_homo_segs(line,segs): #turn an alignment into segs [(RNAME, STRAND L, R), ...]
    #A00208:104:HJCGWDRXX:1:2128:6696:28557-HEK293toRNA      2064    chr1    1109945 255     24M2I1D2I1D33M  *       0       0\
    #GGCCGTGAAATGGGGGGTCAGTTAGTGTGCCTGGCAGCGAGCCATCACTGTTTCCATACCG   :FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF:FFFFFFFFFFFFFFFFFFF:FFF   NH:i:1  HI:i:1  AS:i:25 nM:i:0  NM:i:0  MD:Z:26 jM:B:c,-1jI:B:i,-1       ch:A:1  SA:Z:chr1,1109969,-,21S35M27S,255,0;
    align = line.rstrip('\n').split('\t')
    readID, CHR, POS, CIGAR = align[0], align[2], int(align[3]), align[5]
    STRAND = '-' if '{0:012b}'.format(int(align[1]))[-5] == '1' else '+'
    seglens = [int(i[:-1]) for i in re.findall('[0-9]+M', CIGAR)] #seg lengths
    overlap = len(re.findall('2I1D', CIGAR))
    seg1 = [CHR, POS, POS+seglens[0]+overlap-1, STRAND, seglens[0]+overlap]
    seg2 = [CHR, POS+seglens[0], POS+seglens[0]+seglens[1]+overlap-1, STRAND, seglens[1]+overlap]
    overlapseg = [CHR, POS+seglens[0], POS+seglens[0]+overlap-1, STRAND, overlap]
    segs[readID] = [seg1, seg2, overlapseg]
    return segs

# get gap1 segs
def get_segs(line, segs): #turn an alignment into segs [(RNAME, STRAND L, R), ...]
    align = line.split(); 
    readID, CHR, POS, CIGAR = align[0], align[2], int(align[3]), align[5]
    STRAND = '-' if '{0:012b}'.format(int(align[1]))[-5] == '1' else '+'
    seglens = [int(i[:-1]) for i in re.findall('[0-9]+M', mergeCIGAR(CIGAR))] #seg lengths
    gaplens = [int(i[:-1]) for i in re.findall('[0-9]+N', mergeCIGAR(CIGAR))] #gap lengths
    Ns =[i.rstrip('0123456789') for i in mergeCIGAR(CIGAR).split('M')]
    rx = [] #reference consumed: MD=X
    for N in Ns:
        rx.append(sum([int(i[:-1]) for i in re.findall('[0-9]+[ND=X]', N)]))
    for i in range(len(seglens)): #combine ref and segment lengths to make the junctions
        l, r = POS+sum(rx[:i+1])+sum(seglens[:i]), POS+sum(rx[:i+1])+sum(seglens[:i+1])-1
        if readID not in segs: segs[readID] = []
        segs[readID].append((CHR, int(l), int(r), STRAND))
    return segs

# a: [chr1, 1233, 1347, +]
# b: [chr1, 1230, 1377, +]
def getOverlap(a, b):
    distance = 0
    if a[0]==b[0]:
        overlap = int(min(int(a[2]),int(b[2]))) - int(max(int(a[1]),int(b[1])))
        distance = overlap + 1
    return distance

################################################################################


#3 start processing the input sam file.
################################################################################
segs = {}; inputread = 0
if samtype == 'homo':
    print(timenow()+" Process homo sam file...")
    for line in inputsam:
        if line[0]=='@': continue;
        inputread += 1
        segs = get_homo_segs(line, segs)
    inputsam.close()
    
if samtype == 'gap1' or samtype=='gapm' or samtype=='trans':
    print(timenow()+" Process gap1/gapm/trans sam file...")
    for line in inputsam:
        if line[0]=='@': continue;
        inputread += 1
        segs = get_segs(line, segs)
    inputsam.close()


## calculate the distance
distance_dict = {}
if samtype == 'homo':
    for readID in segs:
        disntance = segs[readID][2][4]
        if disntance not in distance_dict: distance_dict[disntance] = 0
        if disntance>2: distance_dict[disntance] += 1

if samtype == 'gap1' or samtype=='gapm' or samtype=='trans':
    for readID in segs:
        seg_distance = []
        for i in list(combinations(segs[readID], 2)):
            seg_distance.append(getOverlap(i[0], i[1]))
        if abs(min(seg_distance)) not in distance_dict: distance_dict[abs(min(seg_distance))] = 0
        distance_dict[abs(min(seg_distance))] += 1
            
## calculate the distance distribution using intervals
distance_dict_interval = {}
for i in distance_dict:
    distance_dict_interval[ceil(i/interval)] = distance_dict[i]
    

## output bed files
for i in range(1,max(distance_dict_interval)+1,1):
    if i in distance_dict_interval:
        if samtype == 'homo':   output.write('-'+str((i-1)*interval)+'to-'+str(i*interval)+'\t'+str(distance_dict_interval[i])+'\n')
        if samtype == 'gap1' or samtype=='gapm' or samtype=='trans': output.write(str((i-1)*interval)+'to'+str(i*interval)+'\t'+str(distance_dict_interval[i])+'\n')
    #else: output.write(str(i)+'\t0')
output.close()