library(reshape2)

real_cor<-moduleTraitCor
real_P<-moduleTraitPvalue

correl <- function(MEs, shapefeat, n) {v <- cor(MEs, shapefeat, use= "p") #correlate matrix 
                                      non_neg_v  <- sqrt((v)^2) #remove negative values and replace them with their modulus 
                                      sort(non_neg_v,decreasing = T)[n]}

correlP <- function(MEs, shapefeat, n, nSamples) {v <- cor(MEs, shapefeat, use= "p") #correlate matrix 
  moduleTraitPvalue_per = corPvalueStudent(v, nSamples)
  non_neg_v  <-  -log2(moduleTraitPvalue_per)
  sort(non_neg_v, decreasing = T)[n]}

order_real_cor<-melt(real_cor)
order_real_cor$test<-paste(order_real_cor$Var1, order_real_cor$Var2, sep = "_")
names(order_real_cor)[3]<-"cor"
order_real_p<-melt(real_P)
order_real_p$test<-paste(order_real_p$Var1, order_real_p$Var2, sep = "_")
names(order_real_p)[3]<-"p"
combined_cor_p_df_melted<-merge(x = order_real_cor,y = order_real_p, by.x = "test", by.y = "test")
combined_cor_p_df_melted<-combined_cor_p_df_melted[order(combined_cor_p_df_melted$non_neg_cor, decreasing = T),]

order_real_cor$non_neg_cor<-sqrt((order_real_cor$cor)^2)
order_real_cor<-order_real_cor[order(order_real_cor$non_neg_cor, decreasing = T),]
order_real_cor<-data.frame(order_real_cor, number = c(1:length(order_real_cor$cor)))

#for cor 
cor_resample_pvalue_adj<-c()
resampled_dist<-list()
for (number in order_real_cor$number) {
  sim <- replicate(1000, correl(MEs =MEs, # t(apply(apply(MEs,2,sample),1,sample))
                                shapefeat = apply(shapefeat,2,sample),
                                n = number))
  resampled_dist[[number]]<-sim
  P.adj.resample<-sum(sim>order_real_cor$non_neg_cor[number])/length(sim)
  print(paste(order_real_cor$Var1[number], order_real_cor$Var2[number] ,sep = "_"))
  print(number)
  print(P.adj.resample)
  cor_resample_pvalue_adj<-c(cor_resample_pvalue_adj, P.adj.resample)
}
rank_pvalue_cor<-data.frame(c(1:length(cor_resample_pvalue_adj)), cor_resample_pvalue_adj)
real_pvalue_cor<-data.frame(combined_cor_p_df_melted$number, combined_cor_p_df_melted$cor)

#rank_pvalue$minus_logpv=-log2(rank_pvalue$cor_resample_pvalue_adj)
plot(rank_pvalue_cor)
abline(h=0.1, col="blue")
#get CI of empiracl distrution 
CI_resampled<-lapply(resampled_dist, quantile,  c(.025, .975))
CI_resampled_df<-do.call(rbind.data.frame, CI_resampled)
CI_resampled_df$rank<- order_real_cor$number
colnames(CI_resampled_df)<-c("2.5%", "97.5%", "Rank")
#show all the ranks that have a upper CI below the normal significance cut off (P=0.05) & merge with real data by rank. 
sup_table<-merge(x = CI_resampled_df, y = order_real_cor,
                 by.x = "Rank", by.y = "number") 
sup_table$cor<-NULL
sup_table$test<-NULL

correl_coefficient <- function(MEs, shapefeat) {v <- cor(MEs, shapefeat, use= "p") #correlate matrix 
non_neg_v  <- sqrt((v)^2) #remove negative values and replace them with their modulus 
non_neg_v}

sim <- replicate(1000, correl_coefficient(MEs =MEs,
                                          shapefeat = apply(shapefeat,2,sample)))

sup_table$perterbed_p_val<-unlist(lapply(sup_table$non_neg_cor, function(x){sum(x<as.numeric(sim))/length(as.numeric(sim))}))
sup_table_fin<-merge(x=sup_table,y=rank_pvalue_cor,
                     by.x="Rank",by.y="c.1.length.cor_resample_pvalue_adj..")
write_csv(sup_table_fin, file = "~/barker_et_al_2021/barker_et_al_supp/Supp_WGCNA_cor.csv")

# Loess method
sup_table_fin$colour<-paste0(sup_table_fin$cor_resample_pvalue_adj<0.05,
                             "_",
                             sup_table_fin$perterbed_p_val<0.05)
ggplot(sup_table_fin, aes(x=perterbed_p_val, y=cor_resample_pvalue_adj, colour = colour)) + 
  geom_point()+
  theme_classic()
real_P_values<-melt(real_P)
real_P_values$code <- paste0(real_P_values$Var1, "_", real_P_values$Var2)
sup_table_fin$code <- paste0(sup_table_fin$Var1, "_", sup_table_fin$Var2)

done_Df<-merge(x=sup_table_fin,y=real_P_values,
                     by.x="code",by.y="code")
ggplot(done_Df, aes(x=perterbed_p_val, y=value)) + 
  geom_point()+
  theme_classic()

rank_pvalue_cor$log2=-log2(rank_pvalue_cor$cor_resample_pvalue_adj)
colnames(rank_pvalue_cor)<-c("number", "pval", "logtp")
total<-merge(x=rank_pvalue_cor, y=order_real_cor, by.x="number", by.y="number")
P_val_melt<-melt(real_P)
colnames(P_val_melt)<-c("module", "feature", "real_P")
P_val_melt$test<-paste0(P_val_melt$module, "_", P_val_melt$feature)
total_real<-merge(x=P_val_melt, y=total, by.x="test", by.y="test")

conservative<-unique(total_real$module[total_real$real_P < 0.05 & total_real$pval < 0.05])
liberal<-unique(total_real$module[total_real$real_P < 0.05])
liberal[!liberal %in% conservative]

correl_coefficient <- function(MEs, shapefeat) {v <- cor(MEs, shapefeat, use= "p") #correlate matrix 
non_neg_v  <- sqrt((v)^2) #remove negative values and replace them with their modulus 
non_neg_v}

sim <- replicate(1000, correl_coefficient(MEs =MEs,
                                          shapefeat = apply(shapefeat,2,sample)))

cor_to_plot<-rbind(data.frame(log2_cor = total_real$non_neg_cor, variable = "REAL"),
                   data.frame(log2_cor = as.numeric(sim), variable = "SIMULATED"))
library(ggplot2)

# Change density plot line colors by groups
p1<-ggplot(cor_to_plot, aes(x=log2_cor, color=variable)) +
  geom_density()+theme_classic()

# Stacked density plot:
p2<-ggplot(data=cor_to_plot, aes(x=log2_cor, group=variable, fill=variable)) +
  geom_density(adjust=1.2, position="fill") + theme_classic()

library(grid)
grid.newpage()
grid.draw(rbind(ggplotGrob(p1), ggplotGrob(p2), size = "last"))
