get_wgcna <- function(path_wgcna,path_correlations, is.full) {
  
  # Takes output from WGCNA analysis and correlations and produces a list of relevant modules with the gene contained within them. 
  # 
  # AUTHOR:	C.Barker
  # INPUT: 
  #          path_wgcna,          path containing the ENSG of WGCNA modules 
  #          path_correlations,   path of file containing the correlations between WGCNA and variable 
  #          is.full              logical - do you want the full list of wgna modules
  #
  # OUTPUT:   list of the relevant WGCNA modules and the gene names contained within them. 
  
  wgcna<-read.delim(file = path_wgcna,header = FALSE) #~/phenotype_networks/data/modules
  wgcna.genes<-wgcna$V1[grep("ENSG", wgcna$V1)]
  splitAt <- function(x, pos) unname(split(x, cumsum(seq_along(x) %in% pos)))
  wgcna.split<-splitAt(wgcna$V1, grep("ME", wgcna$V1))
  names(wgcna.split)<-wgcna$V1[grep("ME", wgcna$V1)]
  for (x in c(1:length(wgcna.split))) {
    gconvert.table<-gconvert(query = wgcna.split[[x]][-1], 
                             organism = "hsapiens", 
                             target="ENSG", 
                             mthreshold = Inf, 
                             filter_na = FALSE)
    wgcna.split[[x]]<-gconvert.table$name
    cat("\r", "WGCNA module conversion progress:", x/length(wgcna.split)*100, "%")
  }
  if (is.full == T) {
    wgcna.split.correlation<-wgcna.split
  }
  else {
    # get wgcna modules that are strongly correlated with our cell shape traits.  
    correlations_table<-read.delim(file = path_correlations,header = FALSE) #~/phenotype_networks/data/modules
    correlations_table<-correlations_table[correlations_table$V1 != 1,]
    correlations_table$V2<-as.numeric(correlations_table$V2)
    correlations<-correlations_table$V1[correlations_table$V2 < -0.6 | correlations_table$V2 > 0.6]
    
    wgcna.split.correlation<-wgcna.split[correlations] #subset modules that are only correlated with a shape 
  }
  return(wgcna.split.correlation)
}
