	  
#!/usr/bin/Rscript
 
# AUTHOR:	c.g.b 
#
 
 
#set for whether  the script is run locally or in the cluster (codon)
cluster.status = T 
 
#packages required locally 
if (cluster.status == F) {
  pack.lib = NULL
  packages = c("readr")
  mypath<- "/home/charlie/MelanomaProject/melanomaresistance/"
   
   
}else {pack.lib = "/hps/software/users/petsalaki/Rpackages/4_0_3/"
       packages = c("crayon","BiocGenerics","S4Vectors","IRanges", 
		    "TCGAbiolinks","GenomeInfoDb","GenomicRanges" ,
		    "MatrixGenerics","SummarizedExperiment","DESeq2")
       mypath<- "/nfs/research/petsalaki/users/cbarker/TCGA_BRCA/subtype"
}
#import otherwise R wont know where all your dependencies are 
environment(.libPaths)$.lib.loc <- pack.lib

#load packages
suppressPackageStartupMessages(lapply(packages, require, lib.loc = pack.lib, character.only = TRUE))


#####MAIN####

#get data
setwd("/nfs/research/petsalaki/users/cbarker/TCGA_BRCA/morph_8520")
data = readRDS(file = "../tcga_data.RDS")


#set attribute that you would like to study
version<-"morphology"

#set control
cntrl_col<-"sample_type"
cntrl<-"Solid Tissue Normal"



#remove nas
colData(data)[version][,1][colData(data)[cntrl_col][,1] == cntrl]<-"aaCNTRL"
colData(data)$morphology <- relevel(factor(colData(data)$morphology), ref="aaCNTRL")
data <- data[,!is.na(colData(data)[version][,1])]

#Perform DE analysis
ddsSE <- DESeqDataSet(data, design = ~morphology)
keep <- rowSums(counts(ddsSE)) >= 10
ddsSE <- ddsSE[keep,]
ddsSE <- DESeq(ddsSE)
results_names<-resultsNames(ddsSE)
#samples<-unique(colData(data)$paper_days_to_death)

#tested_samples<-samples[!samples %in% cntrl]

for (results in results_names) {
	print(results)
	#important 
	results<-gsub("/", "_", results)
        res <- results(ddsSE, name = results)
	dea <- as.data.frame(res)
	summary(res)
	write.csv(dea, file = paste(results, ".csv", sep=""))
}


