  
#!/usr/bin/Rscript
 
# AUTHOR:	c.g.b 
#
 
 
#set for whether  the script is run locally or in the cluster (codon)
cluster.status = T 
 
#packages required locally 
if (cluster.status == F) {
  pack.lib = NULL
  packages = c("readr")
  mypath<- "/home/charlie/MelanomaProject/melanomaresistance/"
   
   
}else {pack.lib = "/hps/software/users/petsalaki/Rpackages/4_0_3/"
       packages = c("crayon","BiocGenerics","S4Vectors","IRanges", 
		    "TCGAbiolinks","GenomeInfoDb","GenomicRanges" ,
		    "MatrixGenerics","SummarizedExperiment","DESeq2")
       mypath<- "/nfs/research/petsalaki/users/cbarker/TCGA_BRCA/subtype"
}
#import otherwise R wont know where all your dependencies are 
environment(.libPaths)$.lib.loc <- pack.lib

#load packages
suppressPackageStartupMessages(lapply(packages, require, lib.loc = pack.lib, character.only = TRUE))


#####MAIN####

#get data
setwd("/nfs/research/petsalaki/users/cbarker/TCGA_BRCA/subtype")
tcga_data = readRDS(file = "../tcga_data.RDS")

#set attribute that you would like to study 
version<-"paper_pathologic_stage"

#set control 
cntrl<-"Stage_I"



#remove nas 
data <- tcga_data[,!is.na(colData(tcga_data)[version][,1])]
colData(data)[version][,1][colData(data)[version][,1] == cntrl]<-"aaStage_I"


#Perform DE analysis
ddsSE <- DESeqDataSet(data, design = ~paper_pathologic_stage)
keep <- rowSums(counts(ddsSE)) >= 10
ddsSE <- ddsSE[keep,]
ddsSE <- DESeq(ddsSE)
results_names<-resultsNames(ddsSE)
#samples<-unique(colData(data)$paper_days_to_death)


#tested_samples<-samples[!samples %in% cntrl]

for (results in results_names) {
	print(results)
	#important 
	results<-gsub("/", "_", results)
        res <- results(ddsSE, name = results)
	dea <- as.data.frame(res)
	summary(res)
	write.csv(dea, file = paste(results, ".csv", sep=""))
}


