  
#!/usr/bin/Rscript
 
# AUTHOR:	c.g.b 
#
 
 
#trialing this out = if you're running on the cluster, set cluster.status variable to T
cluster.status = T
 
 
#packages required locally 
if (cluster.status == F) {
  pack.lib = NULL
  packages = c("readr")
  mypath<- "/home/charlie/MelanomaProject/melanomaresistance/"
   
   
}else {pack.lib = "/hps/software/users/petsalaki/Rpackages/4_0_3/"
       packages = c("crayon", "TCGAbiolinks")
       mypath<- "/nfs/research/petsalaki/users/cbarker/TCGA_BRCA"
}

#load packages
suppressPackageStartupMessages(lapply(packages, require, lib.loc = pack.lib, character.only = TRUE))





query_TCGA = GDCquery(
  project = "TCGA-SKCM",
  data.category = "Transcriptome Profiling", # parameter enforced by GDCquery
  experimental.strategy = "RNA-Seq",
  workflow.type = "HTSeq - Counts")
GDCdownload(query_TCGA, method = "api", files.per.chunk = 10)
tcga_data <- GDCprepare(query_TCGA)
# Save the data as a file, if you need it later, you can just load this file
# instead of having to run the whole pipeline again
saveRDS(object = tcga_data,
        file = "tcga_data_skcm.RDS",
        compress = F)
