#!/bin/bash

#https://hicexplorer.readthedocs.io/en/latest/content/mES-HiC_analysis.html#build-visualize-and-correct-hi-c-matrix

#create the directories
cd ~
mkdir -p BG3_HiC_KD
cd BG3_HiC_KD/
mkdir -p HiCExplorer
cd HiCExplorer

mkdir -p mapped_files
mkdir -p fastq
mkdir -p hiCmatrix
mkdir -p plots
mkdir -p TADs
mkdir -p compartments

################################################################################
#  download files check that the correct identifiers have been used
################################################################################

cd fastq

fastq-dump --split-files --outdir fastq SRX5014527 #Kc167 rep1
fastq-dump --split-files --outdir fastq SRX5014528 #Kc167 rep2
fastq-dump --split-files --outdir fastq SRX5014529 #BG3 rep1
fastq-dump --split-files --outdir fastq SRX5014530 #BG3 rep2

fastq-dump --split-files --outdir fastq SRX7918778 #BG3 BEAF-32 KD rep1
fastq-dump --split-files --outdir fastq SRX7918779 #BG3 BEAF-32 KD rep2
fastq-dump --split-files --outdir fastq SRX7918780 #BG3 Cp190 Chro KD rep1
fastq-dump --split-files --outdir fastq SRX7918781 #BG3 Cp190 Chro KD rep2
fastq-dump --split-files --outdir fastq SRX7918782 #BG3 BEAF-32 Dref KD rep1
fastq-dump --split-files --outdir fastq SRX7918783 #BG3 BEAF-32 Dref KD rep2

cd ..

################################################################################
#  Subsample the files
################################################################################

#Kc167 rep1
python subsample.py 0.80 fastq/SRX5014527_sub80_1.fastq fastq/SRX5014527_sub80_2.fastq fastq/SRX5014527_sub80_1.fastq fastq/SRX5014527_sub80_2.fastq

#Kc167 rep2
python subsample.py 0.80 fastq/SRX5014528_sub80_1.fastq fastq/SRX5014528_sub80_2.fastq fastq SRX5014528_sub80_1.fastq fastq/SRX5014528_sub80_2.fastq

#BG3 rep1
python subsample.py 0.80 fastq/SRX5014529_sub80_1.fastq fastq/SRX5014529_sub80_2.fastq fastq/SRX5014529_sub80_1.fastq fastq/SRX5014529_sub80_2.fastq

#BG3 rep2
python subsample.py 0.80 fastq/SRX5014530_sub80_1.fastq fastq/SRX5014530_sub80_2.fastq fastq SRX5014530_sub80_1.fastq fastq/SRX5014530_sub80_2.fastq

#BG3 BEAF-32 KD rep1
python subsample.py 0.80 fastq/SRX7918778_sub80_1.fastq fastq/SRX7918778_sub80_2.fastq fastq/SRX7918778_sub80_1.fastq fastq/SRX7918778_sub80_2.fastq

#BG3 BEAF-32 KD rep2
python subsample.py 0.80 fastq/SRX7918779_sub80_1.fastq fastq/SRX7918779_sub80_2.fastq fastq SRX7918779_sub80_1.fastq fastq/SRX7918779_sub80_2.fastq

#BG3 Cp190 Chro KD rep1
python subsample.py 0.80 fastq/SRX7918780_sub80_1.fastq fastq/SRX7918780_sub80_2.fastq fastq/SRX7918780_sub80_1.fastq fastq/SRX7918780_sub80_2.fastq

#BG3 Cp190 Chro KD rep2
python subsample.py 0.80 fastq/SRX7918781_sub80_1.fastq fastq/SRX7918781_sub80_2.fastq fastq SRX7918781_sub80_1.fastq fastq/SRX7918781_sub80_2.fastq

#BG3 BEAF-32 Dref KD rep1
python subsample.py 0.80 fastq/SRX7918782_sub80_1.fastq fastq/SRX7918782_sub80_2.fastq fastq/SRX7918782_sub80_1.fastq fastq/SRX7918782_sub80_2.fastq

#BG3 BEAF-32 Dref KD rep2
python subsample.py 0.80 fastq/SRX7918783_sub80_1.fastq fastq/SRX7918783_sub80_2.fastq fastq SRX7918783_sub80_1.fastq fastq/SRX7918783_sub80_2.fastq

################################################################################
#  align the reads
################################################################################

#download the genome and prepare it
#bwa index -a bwtsw ~/genomes/DM6/dm6.fa

#Kc167 rep1
bwa mem -t 20 -A1 -B4 -E50 -L0 ~/genomes/DM6/dm6.fa  fastq/SRX5014527_sub80_1.fastq | samtools view -Shb - >  mapped_files/SRX5014527_sub80_1.sam
bwa mem -t 20 -A1 -B4 -E50 -L0 ~/genomes/DM6/dm6.fa  fastq/SRX5014527_sub80_2.fastq | samtools view -Shb - >  mapped_files/SRX5014527_sub80_2.sam

#Kc167 rep2
bwa mem -t 20 -A1 -B4 -E50 -L0 ~/genomes/DM6/dm6.fa  fastq/SRX5014528_sub80_1.fastq | samtools view -Shb - >  mapped_files/SRX5014528_sub80_1.sam
bwa mem -t 20 -A1 -B4 -E50 -L0 ~/genomes/DM6/dm6.fa  fastq/SRX5014528_sub80_2.fastq | samtools view -Shb - >  mapped_files/SRX5014528_sub80_2.sam

#BG3 rep1
bwa mem -t 20 -A1 -B4 -E50 -L0 ~/genomes/DM6/dm6.fa fastq/SRX5014529_sub80_1.fastq | samtools view -Shb - > mapped_files/SRX5014529_sub80_1.sam
bwa mem -t 20 -A1 -B4 -E50 -L0 ~/genomes/DM6/dm6.fa fastq/SRX5014529_sub80_2.fastq | samtools view -Shb - > mapped_files/SRX5014529_sub80_2.sam

#BG3 rep2
bwa mem -t 20 -A1 -B4 -E50 -L0 ~/genomes/DM6/dm6.fa fastq/SRX5014530_sub80_1.fastq | samtools view -Shb - > mapped_files/SRX5014530_sub80_1.sam
bwa mem -t 20 -A1 -B4 -E50 -L0 ~/genomes/DM6/dm6.fa fastq/SRX5014530_sub80_2.fastq | samtools view -Shb - > mapped_files/SRX5014530_sub80_2.sam

#BG3 BEAF-32 KD rep1
bwa mem -t 20 -A1 -B4 -E50 -L0 ~/genomes/DM6/dm6.fa fastq/SRX7918778_sub80_1.fastq | samtools view -Shb - > mapped_files/SRX7918778_sub80_1.sam
bwa mem -t 20 -A1 -B4 -E50 -L0 ~/genomes/DM6/dm6.fa fastq/SRX7918778_sub80_2.fastq | samtools view -Shb - > mapped_files/SRX7918778_sub80_2.sam

#BG3 BEAF-32 KD rep2
bwa mem -t 20 -A1 -B4 -E50 -L0 ~/genomes/DM6/dm6.fa fastq/SRX7918779_sub80_1.fastq | samtools view -Shb - > mapped_files/SRX7918779_sub80_1.sam
bwa mem -t 20 -A1 -B4 -E50 -L0 ~/genomes/DM6/dm6.fa fastq/SRX7918779_sub80_2.fastq | samtools view -Shb - > mapped_files/SRX7918779_sub80_2.sam

#BG3 Cp190 Chro KD rep1
bwa mem -t 20 -A1 -B4 -E50 -L0 ~/genomes/DM6/dm6.fa fastq/SRX7918780_sub80_1.fastq | samtools view -Shb - > mapped_files/SRX7918780_sub80_1.sam
bwa mem -t 20 -A1 -B4 -E50 -L0 ~/genomes/DM6/dm6.fa fastq/SRX7918780_sub80_2.fastq | samtools view -Shb - > mapped_files/SRX7918780_sub80_2.sam

#BG3 Cp190 Chro KD rep2
bwa mem -t 20 -A1 -B4 -E50 -L0 ~/genomes/DM6/dm6.fa fastq/SRX7918781_sub80_1.fastq | samtools view -Shb - > mapped_files/SRX7918781_sub80_1.sam
bwa mem -t 20 -A1 -B4 -E50 -L0 ~/genomes/DM6/dm6.fa fastq/SRX7918781_sub80_2.fastq | samtools view -Shb - > mapped_files/SRX7918781_sub80_2.sam

#BG3 BEAF-32 Dref KD rep1
bwa mem -t 20 -A1 -B4 -E50 -L0 ~/genomes/DM6/dm6.fa fastq/SRX7918782_sub80_1.fastq | samtools view -Shb - > mapped_files/SRX7918782_sub80_1.sam
bwa mem -t 20 -A1 -B4 -E50 -L0 ~/genomes/DM6/dm6.fa fastq/SRX7918782_sub80_2.fastq | samtools view -Shb - > mapped_files/SRX7918782_sub80_2.sam

#BG3 BEAF-32 Dref KD rep2
bwa mem -t 20 -A1 -B4 -E50 -L0 ~/genomes/DM6/dm6.fa fastq/SRX7918783_sub80_1.fastq | samtools view -Shb - > mapped_files/SRX7918783_sub80_1.sam
bwa mem -t 20 -A1 -B4 -E50 -L0 ~/genomes/DM6/dm6.fa fastq/SRX7918783_sub80_2.fastq | samtools view -Shb - > mapped_files/SRX7918783_sub80_2.sam

################################################################################
# Build Matrices Kc167 WT DPNII for TADs
################################################################################

#WT rep1 150bp
hicBuildMatrix --samFiles mapped_files/SRX5014527_sub80_1.sam mapped_files/SRX5014527_sub80_2.sam \
               --restrictionCutFile dm6_DPNII_positions.bed \
               --minDistance 150 \
               --threads 30 \
                --outBam Kc167_WT_sub80_rep1_hic_dpnII.bam \
                -o hiCmatrix/Kc167_WT_sub80_rep1_hic_matrix_dpnII.h5 \
                --QCfolder hiCmatrix/Kc167_WT_sub80_rep1_hic_matrix_dpnII_hicQC

#WT rep2 150bp
hicBuildMatrix --samFiles mapped_files/SRX5014528_sub80_1.sam mapped_files/SRX5014528_sub80_2.sam \
               --restrictionCutFile dm6_DPNII_positions.bed \
               --minDistance 150 \
               --threads 30 \
                --outBam Kc167_WT_sub80_rep2_hic_dpnII.bam \
                -o hiCmatrix/Kc167_WT_sub80_rep2_hic_matrix_dpnII.h5 \
                --QCfolder hiCmatrix/Kc167_WT_sub80_rep2_hic_matrix_dpnII_hicQC


#Merge (sum) matrices from replicates
hicSumMatrices -m hiCmatrix/Kc167_WT_sub80_rep1_hic_matrix_dpnII.h5 hiCmatrix/Kc167_WT_sub80_rep2_hic_matrix_dpnII.h5 \
                -o hiCmatrix/Kc167_WT_sub80_merged_hic_matrix_dpnII.h5

#Generate diagnostic plots
hicCorrectMatrix diagnostic_plot \
-m hiCmatrix/Kc167_WT_sub80_merged_hic_matrix_dpnII.h5 -o plots/Kc167_WT_sub80_merged_hic_matrix_dpnII_diagnostic_plot.png

#Correction of Hi-C matrix
hicCorrectMatrix correct --filterThreshold -1.4 5 -m hiCmatrix/Kc167_WT_sub80_merged_hic_matrix_dpnII.h5 -o hiCmatrix/Kc167_WT_sub80_merged_hic_matrix_dpnII_corrected.h5

################################################################################
# Build Matrices BG3 WT DPNII for TADs
################################################################################

#WT rep1 150bp
hicBuildMatrix --samFiles mapped_files/SRX5014529_sub80_1.sam mapped_files/SRX5014529_sub80_2.sam \
               --restrictionCutFile dm6_DPNII_positions.bed \
               --minDistance 150 \
               --threads 30 \
                --outBam BG3_WT_sub80_rep1_hic_dpnII.bam \
                -o hiCmatrix/BG3_WT_sub80_rep1_hic_matrix_dpnII.h5 \
                --QCfolder hiCmatrix/BG3_WT_sub80_rep1_hic_matrix_dpnII_hicQC

#WT rep2 150bp
hicBuildMatrix --samFiles mapped_files/SRX5014530_sub80_1.sam mapped_files/SRX5014530_sub80_2.sam \
               --restrictionCutFile dm6_DPNII_positions.bed \
               --minDistance 150 \
               --threads 30 \
                --outBam BG3_WT_sub80_rep2_hic_dpnII.bam \
                -o hiCmatrix/BG3_WT_sub80_rep2_hic_matrix_dpnII.h5 \
                --QCfolder hiCmatrix/BG3_WT_sub80_rep2_hic_matrix_dpnII_hicQC


#Merge (sum) matrices from replicates
hicSumMatrices -m hiCmatrix/BG3_WT_sub80_rep1_hic_matrix_dpnII.h5 hiCmatrix/BG3_WT_sub80_rep2_hic_matrix_dpnII.h5 \
                -o hiCmatrix/BG3_WT_sub80_merged_hic_matrix_dpnII.h5

#Generate diagnostic plots
hicCorrectMatrix diagnostic_plot \
-m hiCmatrix/BG3_WT_sub80_merged_hic_matrix_dpnII.h5 -o plots/BG3_WT_sub80_merged_hic_matrix_dpnII_diagnostic_plot.png


#Correction of Hi-C matrix
hicCorrectMatrix correct --filterThreshold -1.4 5 -m hiCmatrix/BG3_WT_sub80_merged_hic_matrix_dpnII.h5 -o hiCmatrix/BG3_WT_sub80_merged_hic_matrix_dpnII_corrected.h5


################################################################################
# Build Matrices BG3 BEAF_KD DPNII for TADs
################################################################################

#BEAF_KD rep1 150bp
hicBuildMatrix --samFiles mapped_files/SRX7918778_sub80_1.sam mapped_files/SRX7918778_sub80_2.sam \
               --restrictionCutFile dm6_DPNII_positions.bed \
               --minDistance 150 \
               --threads 30 \
                --outBam BG3_BEAF_KD_sub80_rep1_hic_dpnII.bam \
                -o hiCmatrix/BG3_BEAF_KD_sub80_rep1_hic_matrix_dpnII.h5 \
                --QCfolder hiCmatrix/BG3_BEAF_KD_sub80_rep1_hic_matrix_dpnII_hicQC

#BEAF_KD rep2 150bp
hicBuildMatrix --samFiles mapped_files/SRX7918779_sub80_1.sam mapped_files/SRX7918779_sub80_2.sam \
               --restrictionCutFile dm6_DPNII_positions.bed \
               --minDistance 150 \
               --threads 30 \
                --outBam BG3_BEAF_KD_sub80_rep2_hic_dpnII.bam \
                -o hiCmatrix/BG3_BEAF_KD_sub80_rep2_hic_matrix_dpnII.h5 \
                --QCfolder hiCmatrix/BG3_BEAF_KD_sub80_rep2_hic_matrix_dpnII_hicQC


#Merge (sum) matrices from replicates
hicSumMatrices -m hiCmatrix/BG3_BEAF_KD_sub80_rep1_hic_matrix_dpnII.h5 hiCmatrix/BG3_BEAF_KD_sub80_rep2_hic_matrix_dpnII.h5 \
                -o hiCmatrix/BG3_BEAF_KD_sub80_merged_hic_matrix_dpnII.h5

#Generate diagnostic plots
hicCorrectMatrix diagnostic_plot \
-m hiCmatrix/BG3_BEAF_KD_sub80_merged_hic_matrix_dpnII.h5 -o plots/BG3_BEAF_KD_sub80_merged_hic_matrix_dpnII_diagnostic_plot.png

#Correction of Hi-C matrix
hicCorrectMatrix correct --filterThreshold -1.2 5 -m hiCmatrix/BG3_BEAF_KD_sub80_merged_hic_matrix_dpnII.h5 -o hiCmatrix/BG3_BEAF_KD_sub80_merged_hic_matrix_dpnII_corrected.h5


################################################################################
# Build Matrices BG3 Cp190_Chrom_KD DPNII for TADs
################################################################################

#Cp190_Chrom_KD rep1 150bp
hicBuildMatrix --samFiles mapped_files/SRX7918780_sub80_1.sam mapped_files/SRX7918780_sub80_2.sam \
               --restrictionCutFile dm6_DPNII_positions.bed \
               --minDistance 150 \
               --threads 30 \
                --outBam BG3_Cp190_Chrom_KD_sub80_rep1_hic_dpnII.bam \
                -o hiCmatrix/BG3_Cp190_Chrom_KD_sub80_rep1_hic_matrix_dpnII.h5 \
                --QCfolder hiCmatrix/BG3_Cp190_Chrom_KD_sub80_rep1_hic_matrix_dpnII_hicQC

#Cp190_Chrom_KD rep2 150bp
hicBuildMatrix --samFiles mapped_files/SRX7918781_sub80_1.sam mapped_files/SRX7918781_sub80_2.sam \
               --restrictionCutFile dm6_DPNII_positions.bed \
               --minDistance 150 \
               --threads 30 \
                --outBam BG3_Cp190_Chrom_KD_sub80_rep2_hic_dpnII.bam \
                -o hiCmatrix/BG3_Cp190_Chrom_KD_sub80_rep2_hic_matrix_dpnII.h5 \
                --QCfolder hiCmatrix/BG3_Cp190_Chrom_KD_sub80_rep2_hic_matrix_dpnII_hicQC


#Merge (sum) matrices from replicates
hicSumMatrices -m hiCmatrix/BG3_Cp190_Chrom_KD_sub80_rep1_hic_matrix_dpnII.h5 hiCmatrix/BG3_Cp190_Chrom_KD_sub80_rep2_hic_matrix_dpnII.h5 \
                -o hiCmatrix/BG3_Cp190_Chrom_KD_sub80_merged_hic_matrix_dpnII.h5

#Generate diagnostic plots
hicCorrectMatrix diagnostic_plot \
-m hiCmatrix/BG3_Cp190_Chrom_KD_sub80_merged_hic_matrix_dpnII.h5 -o plots/BG3_Cp190_Chrom_KD_sub80_merged_hic_matrix_dpnII_diagnostic_plot.png

#Correction of Hi-C matrix
hicCorrectMatrix correct --filterThreshold -1.2 5 -m hiCmatrix/BG3_Cp190_Chrom_KD_sub80_merged_hic_matrix_dpnII.h5 -o hiCmatrix/BG3_Cp190_Chrom_KD_sub80_merged_hic_matrix_dpnII_corrected.h5

################################################################################
# Build Matrices BG3 BEAF_DREF_KD DPNII for TADs
################################################################################

#BEAF_DREF_KD rep1 150bp
hicBuildMatrix --samFiles mapped_files/SRX7918782_sub80_1.sam mapped_files/SRX7918782_sub80_2.sam \
               --restrictionCutFile dm6_DPNII_positions.bed \
               --minDistance 150 \
               --threads 30 \
                --outBam BG3_BEAF_DREF_KD_sub80_rep1_hic_dpnII.bam \
                -o hiCmatrix/BG3_BEAF_DREF_KD_sub80_rep1_hic_matrix_dpnII.h5 \
                --QCfolder hiCmatrix/BG3_BEAF_DREF_KD_sub80_rep1_hic_matrix_dpnII_hicQC

#BEAF_DREF_KD rep2 150bp
hicBuildMatrix --samFiles mapped_files/SRX7918783_sub80_1.sam mapped_files/SRX7918783_sub80_2.sam \
               --restrictionCutFile dm6_DPNII_positions.bed \
               --minDistance 150 \
               --threads 30 \
                --outBam BG3_BEAF_DREF_KD_sub80_rep2_hic_dpnII.bam \
                -o hiCmatrix/BG3_BEAF_DREF_KD_sub80_rep2_hic_matrix_dpnII.h5 \
                --QCfolder hiCmatrix/BG3_BEAF_DREF_KD_sub80_rep2_hic_matrix_dpnII_hicQC


#Merge (sum) matrices from replicates
hicSumMatrices -m hiCmatrix/BG3_BEAF_DREF_KD_sub80_rep1_hic_matrix_dpnII.h5 hiCmatrix/BG3_BEAF_DREF_KD_sub80_rep2_hic_matrix_dpnII.h5 \
                -o hiCmatrix/BG3_BEAF_DREF_KD_sub80_merged_hic_matrix_dpnII.h5

#Generate diagnostic plots
hicCorrectMatrix diagnostic_plot \
-m hiCmatrix/BG3_BEAF_DREF_KD_sub80_merged_hic_matrix_dpnII.h5 -o plots/BG3_BEAF_DREF_KD_sub80_merged_hic_matrix_dpnII_diagnostic_plot.png

#Correction of Hi-C matrix
hicCorrectMatrix correct --filterThreshold -1.2 5 -m hiCmatrix/BG3_BEAF_DREF_KD_sub80_merged_hic_matrix_dpnII.h5 -o hiCmatrix/BG3_BEAF_DREF_KD_sub80_merged_hic_matrix_dpnII_corrected.h5

################################################################################
# call TADs cells
################################################################################

hicFindTADs -m hiCmatrix/Kc167_WT_sub80_merged_hic_matrix_dpnII_corrected.h5 \
--outPrefix TADs/Kc167_WT_sub80_merged_dpnII \
--correctForMultipleTesting fdr \
--numberOfProcessors 30 \
--minBoundaryDistance 5000 --thresholdComparisons 0.01 --delta 0.04 \
--step 2000

hicFindTADs -m hiCmatrix/Kc167_WT_sub80_merged_hic_matrix_dpnII_corrected.h5 \
--outPrefix TADs/Kc167_WT_sub80_merged_dpnII_strong \
--correctForMultipleTesting fdr \
--numberOfProcessors 30 \
--minBoundaryDistance 5000 --thresholdComparisons 0.01 --delta 0.08 \
--step 2000

hicFindTADs -m hiCmatrix/BG3_WT_sub80_merged_hic_matrix_dpnII_corrected.h5 \
--outPrefix TADs/BG3_WT_sub80_merged_dpnII \
--correctForMultipleTesting fdr \
--numberOfProcessors 30 \
--minBoundaryDistance 5000 --thresholdComparisons 0.01 --delta 0.04 \
--step 2000

hicFindTADs -m hiCmatrix/BG3_WT_sub80_merged_hic_matrix_dpnII_corrected.h5 \
--outPrefix TADs/BG3_WT_sub80_merged_dpnII_strong \
--correctForMultipleTesting fdr \
--numberOfProcessors 30 \
--minBoundaryDistance 5000 --thresholdComparisons 0.01 --delta 0.08 \
--step 2000

hicFindTADs -m hiCmatrix/BG3_BEAF_DREF_KD_sub80_merged_hic_matrix_dpnII_corrected.h5 \
--outPrefix TADs/BG3_BEAF_DREF_KD_sub80_merged_dpnII \
--correctForMultipleTesting fdr \
--numberOfProcessors 30 \
--minBoundaryDistance 5000 --thresholdComparisons 0.01 --delta 0.04 \
--step 2000

hicFindTADs -m hiCmatrix/BG3_BEAF_DREF_KD_sub80_merged_hic_matrix_dpnII_corrected.h5 \
--outPrefix TADs/BG3_BEAF_DREF_KD_sub80_merged_dpnII_strong \
--correctForMultipleTesting fdr \
--numberOfProcessors 30 \
--minBoundaryDistance 5000 --thresholdComparisons 0.01 --delta 0.08 \
--step 2000

hicFindTADs -m hiCmatrix/BG3_BEAF_KD_sub80_merged_hic_matrix_dpnII_corrected.h5 \
--outPrefix TADs/BG3_BEAF_KD_sub80_merged_dpnII \
--correctForMultipleTesting fdr \
--numberOfProcessors 30 \
--minBoundaryDistance 5000 --thresholdComparisons 0.01 --delta 0.04 \
--step 2000

hicFindTADs -m hiCmatrix/BG3_BEAF_KD_sub80_merged_hic_matrix_dpnII_corrected.h5 \
--outPrefix TADs/BG3_BEAF_KD_sub80_merged_dpnII_strong \
--correctForMultipleTesting fdr \
--numberOfProcessors 30 \
--minBoundaryDistance 5000 --thresholdComparisons 0.01 --delta 0.08 \
--step 2000

hicFindTADs -m hiCmatrix/BG3_Cp190_Chrom_KD_sub80_merged_hic_matrix_dpnII_corrected.h5 \
--outPrefix TADs/BG3_Cp190_Chrom_KD_sub80_merged_dpnII \
--correctForMultipleTesting fdr \
--numberOfProcessors 30 \
--minBoundaryDistance 5000 --thresholdComparisons 0.01 --delta 0.04 \
--step 2000

hicFindTADs -m hiCmatrix/BG3_Cp190_Chrom_KD_sub80_merged_hic_matrix_dpnII_corrected.h5 \
--outPrefix TADs/BG3_Cp190_Chrom_KD_sub80_merged_dpnII_strong \
--correctForMultipleTesting fdr \
--numberOfProcessors 30 \
--minBoundaryDistance 5000 --thresholdComparisons 0.01 --delta 0.08 \
--step 2000

################################################################################
# call loops
################################################################################

cd ~/BG3_HiC_KD
mkdir -p juicer
cd juicer
mkdir -p genome

#custom genome dm6
cd ~/genome/
bwa index dm6.fa
python /usr/local/juicer/misc/generate_site_positions.py DpnII dm6 dm6.fa
awk 'BEGIN{OFS="\t"}{print $1, $NF}'  dm6_DpnII.txt > dm6.chrom.sizes
awk 'BEGIN{OFS="\t"}{print $1, $NF}'  dm6_DpnII.txt
gawk 'BEGIN{OFS="\t"}{print $1, $NF}'  dm6_DpnII.txt
less dm6.chrom.sizes

mkdir -p BG3_WT_HiC_sub80
cd BG3_WT_HiC_sub80
mkdir -p fastq
cp ~/BG3_HiC_KD/HiCExplorer/fastq/SRX5014529_sub80_1.fastq fastq/SRX5014529_sub80_R1.fastq
cp ~/BG3_HiC_KD/HiCExplorer/fastq/SRX5014529_sub80_2.fastq fastq/SRX5014529_sub80_R2.fastq
cp ~/BG3_HiC_KD/HiCExplorer/fastq/SRX5014530_sub80_1.fastq fastq/SRX5014530_sub80_R1.fastq
cp ~/BG3_HiC_KD/HiCExplorer/fastq/SRX5014530_sub80_2.fastq fastq/SRX5014530_sub80_R2.fastq
cd ..

mkdir -p BG3_BEAF_KD_HiC_sub80
cd BG3_BEAF_KD_HiC_sub80
mkdir -p fastq
cp ~/BG3_HiC_KD/HiCExplorer/fastq/SRX7918778_sub80_1.fastq fastq/SRX7918778_sub80_R1.fastq
cp ~/BG3_HiC_KD/HiCExplorer/fastq/SRX7918778_sub80_2.fastq fastq/SRX7918778_sub80_R2.fastq
cp ~/BG3_HiC_KD/HiCExplorer/fastq/SRX7918779_sub80_1.fastq fastq/SRX7918779_sub80_R1.fastq
cp ~/BG3_HiC_KD/HiCExplorer/fastq/SRX7918779_sub80_2.fastq fastq/SRX7918779_sub80_R2.fastq
cd ..

mkdir -p BG3_Cp190_Chrom_KD_HiC_sub80
cd BG3_Cp190_Chrom_KD_HiC_sub80
mkdir -p fastq
cp ~/BG3_HiC_KD/HiCExplorer/fastq/SRX7918780_sub80_1.fastq fastq/SRX7918780_sub80_R1.fastq
cp ~/BG3_HiC_KD/HiCExplorer/fastq/SRX7918780_sub80_2.fastq fastq/SRX7918780_sub80_R2.fastq
cp ~/BG3_HiC_KD/HiCExplorer/fastq/SRX7918781_sub80_1.fastq fastq/SRX7918781_sub80_R1.fastq
cp ~/BG3_HiC_KD/HiCExplorer/fastq/SRX7918781_sub80_2.fastq fastq/SRX7918781_sub80_R2.fastq
cd ..

mkdir -p BG3_BEAF_DREF_KD_HiC_sub80
cd BG3_BEAF_DREF_KD_HiC_sub80
mkdir -p fastq
cp ~/BG3_HiC_KD/HiCExplorer/fastq/SRX7918782_sub80_1.fastq fastq/SRX7918782_sub80_R1.fastq
cp ~/BG3_HiC_KD/HiCExplorer/fastq/SRX7918782_sub80_2.fastq fastq/SRX7918782_sub80_R2.fastq
cp ~/BG3_HiC_KD/HiCExplorer/fastq/SRX7918783_sub80_1.fastq fastq/SRX7918783_sub80_R1.fastq
cp ~/BG3_HiC_KD/HiCExplorer/fastq/SRX7918783_sub80_2.fastq fastq/SRX7918783_sub80_R2.fastq
cd ../../

#call preprocessing pipeline
~/juicer/CPU/juicer.sh -t 30 -z ~/BG3_HiC_KD/juicer/genome/dm6.fa -p ~/BG3_HiC_KD/juicer/genome/dm6.chrom.sizes -y ~/BG3_HiC_KD/juicer/genome/dm6_DpnII.txt -d ~/BG3_HiC_KD/juicer/BG3_WT_HiC_sub80

~/juicer/CPU/juicer.sh -t 30 -z ~/BG3_HiC_KD/juicer/genome/dm6.fa -p ~/BG3_HiC_KD/juicer/genome/dm6.chrom.sizes -y ~/BG3_HiC_KD/juicer/genome/dm6_DpnII.txt -d ~/BG3_HiC_KD/juicer/BG3_BEAF_KD_HiC_sub80

~/juicer/CPU/juicer.sh -t 30 -z ~/BG3_HiC_KD/juicer/genome/dm6.fa -p ~/BG3_HiC_KD/juicer/genome/dm6.chrom.sizes -y ~/BG3_HiC_KD/juicer/genome/dm6_DpnII.txt -d ~/BG3_HiC_KD/juicer/BG3_Cp190_Chrom_KD_HiC_sub80

~/juicer/CPU/juicer.sh -t 30 -z ~/BG3_HiC_KD/juicer/genome/dm6.fa -p ~/BG3_HiC_KD/juicer/genome/dm6.chrom.sizes -y ~/BG3_HiC_KD/juicer/genome/dm6_DpnII.txt -d ~/BG3_HiC_KD/juicer/BG3_BEAF_DREF_KD_HiC_sub80

#generate the hic files
java -Xmx10g -jar ~/myJuicerDir/scripts/common/juicer_tools.jar pre -q 30 -r 500,1000,2000,5000,10000,20000,25000 ~/BG3_HiC_KD/juicer/BG3_WT_HiC_sub80_sub80/aligned/merged_nodups.txt ~/BG3_HiC_KD/juicer/BG3_WT_HiC_sub80_sub80/aligned/BG3_WT_HiC_sub80_sub80.hic ~/BG3_HiC_KD/juicer/genome/dm6.chrom.sizes

java -Xmx10g -jar ~/myJuicerDir/scripts/common/juicer_tools.jar pre -q 30 -r 500,1000,2000,5000,10000,20000,25000 ~/BG3_HiC_KD/juicer/BG3_BEAF_KD_HiC_sub80/aligned/merged_nodups.txt ~/BG3_HiC_KD/juicer/BG3_BEAF_KD_HiC_sub80/aligned/BG3_BEAF_KD_HiC_sub80.hic ~/BG3_HiC_KD/juicer/genome/dm6.chrom.sizes

java -Xmx10g -jar ~/myJuicerDir/scripts/common/juicer_tools.jar pre -q 30 -r 500,1000,2000,5000,10000,20000,25000 ~/BG3_HiC_KD/juicer/BG3_Cp190_Chrom_KD_HiC_sub80/aligned/merged_nodups.txt ~/BG3_HiC_KD/juicer/BG3_Cp190_Chrom_KD_HiC_sub80/aligned/BG3_Cp190_Chrom_KD_HiC_sub80.hic ~/BG3_HiC_KD/juicer/genome/dm6.chrom.sizes

java -Xmx10g -jar ~/myJuicerDir/scripts/common/juicer_tools.jar pre -q 30 -r 500,1000,2000,5000,10000,20000,25000 ~/BG3_HiC_KD/juicer/BG3_BEAF_DREF_KD_HiC_sub80/aligned/merged_nodups.txt ~/BG3_HiC_KD/juicer/BG3_BEAF_DREF_KD_HiC_sub80/aligned/BG3_BEAF_DREF_KD_HiC_sub80.hic ~/BG3_HiC_KD/juicer/genome/dm6.chrom.sizes

#call chromatin loops
java -Xms512m -Xmx2048m -jar ~/myJuicerDir/scripts/common/juicer_tools.jar hiccups -k KR -r 2000 -f 0.05 -p 5 -i 10 -t 0.02,1.5,1.75,2 -d 20000 ~/BG3_HiC_KD/juicer/BG3_WT_HiC_sub80_sub80/aligned/BG3_WT_HiC_sub80_sub80.hic ~/BG3_HiC_KD/juicer/BG3_WT_HiC_sub80_sub80/BG3_WT_HiC_sub80_sub80_hiccups_loops_2kb_05fdr

java -Xms512m -Xmx2048m -jar ~/myJuicerDir/scripts/common/juicer_tools.jar hiccups -k KR -r 2000 -f 0.05 -p 5 -i 10 -t 0.02,1.5,1.75,2 -d 20000 ~/BG3_HiC_KD/juicer/BG3_BEAF_KD_HiC_sub80/aligned/BG3_BEAF_KD_HiC_sub80.hic ~/BG3_HiC_KD/juicer/BG3_BEAF_KD_HiC_sub80/BG3_BEAF_KD_HiC_sub80_hiccups_loops_2kb_05fdr

java -Xms512m -Xmx2048m -jar ~/myJuicerDir/scripts/common/juicer_tools.jar hiccups -k KR -r 2000 -f 0.05 -p 5 -i 10 -t 0.02,1.5,1.75,2 -d 20000 ~/BG3_HiC_KD/juicer/BG3_Cp190_Chrom_KD_HiC_sub80/aligned/BG3_Cp190_Chrom_KD_HiC_sub80.hic ~/BG3_HiC_KD/juicer/BG3_Cp190_Chrom_KD_HiC_sub80/BG3_Cp190_Chrom_KD_HiC_sub80_hiccups_loops_2kb_05fdr

java -Xms512m -Xmx2048m -jar ~/myJuicerDir/scripts/common/juicer_tools.jar hiccups -k KR -r 2000 -f 0.05 -p 5 -i 10 -t 0.02,1.5,1.75,2 -d 20000 ~/BG3_HiC_KD/juicer/BG3_BEAF_DREF_KD_HiC_sub80/aligned/BG3_BEAF_DREF_KD_HiC_sub80.hic ~/BG3_HiC_KD/juicer/BG3_BEAF_DREF_KD_HiC_sub80/BG3_BEAF_DREF_KD_HiC_sub80_hiccups_loops_2kb_05fdr

