#!/bin/bash

#create the directories
cd ~
mkdir -p BG3_HiC_KD
cd BG3_HiC_KD/
mkdir -p RNAseq
cd RNAseq


################################################################################
#  download files check that the correct identifiers have been used.
################################################################################
cd fastq

fastq-dump --split-files --outdir fastq SRX7918784 #BG3 WT rep1
fastq-dump --split-files --outdir fastq SRX7918785 #BG3 WT rep2
fastq-dump --split-files --outdir fastq SRX7918786 #BG3 WT rep3

fastq-dump --split-files --outdir fastq SRX7918787 #BG3 BEAF-32 KD rep1
fastq-dump --split-files --outdir fastq SRX7918788 #BG3 BEAF-32 KD rep2
fastq-dump --split-files --outdir fastq SRX7918789 #BG3 BEAF-32 KD rep3

fastq-dump --split-files --outdir fastq SRX7918790 #BG3 Cp190 Chro KD rep1
fastq-dump --split-files --outdir fastq SRX7918791 #BG3 Cp190 Chro KD rep2
fastq-dump --split-files --outdir fastq SRX7918792 #BG3 Cp190 Chro KD rep3

fastq-dump --split-files --outdir fastq SRX7918793 #BG3 BEAF-32 Dref KD rep1
fastq-dump --split-files --outdir fastq SRX7918794 #BG3 BEAF-32 Dref KD rep2
fastq-dump --split-files --outdir fastq SRX7918795 #BG3 BEAF-32 Dref KD rep3

cd ..


################################################################################
# Trimming with Trimmomatic v0.39
################################################################################
mkdir -p trimmed

#for f in *.fa; do (cat "${f}"; echo) >> adapters.fa; done

java -jar Trimmomatic-0.39/trimmomatic-0.39.jar PE -threads 8 -phred33 fastq/SRX7918784_1.fq.gz fastq/SRX7918784_2.fq.gz trimmed/SRX7918784_1.fq trimmed/SRX7918784_1_unpaired.fq trimmed/SRX7918784_2.fq trimmed/SRX7918784_2_unpaired.fq ILLUMINACLIP:Trimmomatic-0.39/adapters/adapters.fa:2:30:10 LEADING:3 TRAILING:3 SLIDINGWINDOW:4:15 MINLEN:25

java -jar Trimmomatic-0.39/trimmomatic-0.39.jar PE -threads 8 -phred33 fastq/SRX7918785_1.fq.gz fastq/SRX7918785_2.fq.gz trimmed/SRX7918785_1.fq trimmed/SRX7918785_1_unpaired.fq trimmed/SRX7918785_2.fq trimmed/SRX7918785_2_unpaired.fq ILLUMINACLIP:Trimmomatic-0.39/adapters/adapters.fa:2:30:10 LEADING:3 TRAILING:3 SLIDINGWINDOW:4:15 MINLEN:25

java -jar Trimmomatic-0.39/trimmomatic-0.39.jar PE -threads 8 -phred33 fastq/SRX7918786_1.fq.gz fastq/SRX7918786_2.fq.gz trimmed/SRX7918786_1.fq trimmed/SRX7918786_1_unpaired.fq trimmed/SRX7918786_2.fq trimmed/SRX7918786_2_unpaired.fq ILLUMINACLIP:Trimmomatic-0.39/adapters/adapters.fa:2:30:10 LEADING:3 TRAILING:3 SLIDINGWINDOW:4:15 MINLEN:25


java -jar Trimmomatic-0.39/trimmomatic-0.39.jar PE -threads 8 -phred33 fastq/SRX7918787_1.fq.gz fastq/SRX7918787_2.fq.gz trimmed/SRX7918787_1.fq trimmed/SRX7918787_1_unpaired.fq trimmed/SRX7918787_2.fq trimmed/SRX7918787_2_unpaired.fq ILLUMINACLIP:Trimmomatic-0.39/adapters/adapters.fa:2:30:10 LEADING:3 TRAILING:3 SLIDINGWINDOW:4:15 MINLEN:25

java -jar Trimmomatic-0.39/trimmomatic-0.39.jar PE -threads 8 -phred33 fastq/SRX7918788_1.fq.gz fastq/SRX7918788_2.fq.gz trimmed/SRX7918788_1.fq trimmed/SRX7918788_1_unpaired.fq trimmed/SRX7918788_2.fq trimmed/SRX7918788_2_unpaired.fq ILLUMINACLIP:Trimmomatic-0.39/adapters/adapters.fa:2:30:10 LEADING:3 TRAILING:3 SLIDINGWINDOW:4:15 MINLEN:25

java -jar Trimmomatic-0.39/trimmomatic-0.39.jar PE -threads 8 -phred33 fastq/SRX7918789_1.fq.gz fastq/SRX7918789_2.fq.gz trimmed/SRX7918789_1.fq trimmed/SRX7918789_1_unpaired.fq trimmed/SRX7918789_2.fq trimmed/SRX7918789_2_unpaired.fq ILLUMINACLIP:Trimmomatic-0.39/adapters/adapters.fa:2:30:10 LEADING:3 TRAILING:3 SLIDINGWINDOW:4:15 MINLEN:25

java -jar Trimmomatic-0.39/trimmomatic-0.39.jar PE -threads 8 -phred33 fastq/SRX7918790_1.fq.gz fastq/SRX7918790_2.fq.gz trimmed/SRX7918790_1.fq trimmed/SRX7918790_1_unpaired.fq trimmed/SRX7918790_2.fq trimmed/SRX7918790_2_unpaired.fq ILLUMINACLIP:Trimmomatic-0.39/adapters/adapters.fa:2:30:10 LEADING:3 TRAILING:3 SLIDINGWINDOW:4:15 MINLEN:25

java -jar Trimmomatic-0.39/trimmomatic-0.39.jar PE -threads 8 -phred33 fastq/SRX7918791_1.fq.gz fastq/SRX7918791_2.fq.gz trimmed/SRX7918791_1.fq trimmed/SRX7918791_1_unpaired.fq trimmed/SRX7918791_2.fq trimmed/SRX7918791_2_unpaired.fq ILLUMINACLIP:Trimmomatic-0.39/adapters/adapters.fa:2:30:10 LEADING:3 TRAILING:3 SLIDINGWINDOW:4:15 MINLEN:25

java -jar Trimmomatic-0.39/trimmomatic-0.39.jar PE -threads 8 -phred33 fastq/SRX7918792_1.fq.gz fastq/SRX7918792_2.fq.gz trimmed/SRX7918792_1.fq trimmed/SRX7918792_1_unpaired.fq trimmed/SRX7918792_2.fq trimmed/SRX7918792_2_unpaired.fq ILLUMINACLIP:Trimmomatic-0.39/adapters/adapters.fa:2:30:10 LEADING:3 TRAILING:3 SLIDINGWINDOW:4:15 MINLEN:25

java -jar Trimmomatic-0.39/trimmomatic-0.39.jar PE -threads 8 -phred33 fastq/SRX7918793_1.fq.gz fastq/SRX7918793_2.fq.gz trimmed/SRX7918793_1.fq trimmed/SRX7918793_1_unpaired.fq trimmed/SRX7918793_2.fq trimmed/SRX7918793_2_unpaired.fq ILLUMINACLIP:Trimmomatic-0.39/adapters/adapters.fa:2:30:10 LEADING:3 TRAILING:3 SLIDINGWINDOW:4:15 MINLEN:25

java -jar Trimmomatic-0.39/trimmomatic-0.39.jar PE -threads 8 -phred33 fastq/SRX7918794_1.fq.gz fastq/SRX7918794_2.fq.gz trimmed/SRX7918794_1.fq trimmed/SRX7918794_1_unpaired.fq trimmed/SRX7918794_2.fq trimmed/SRX7918794_2_unpaired.fq ILLUMINACLIP:Trimmomatic-0.39/adapters/adapters.fa:2:30:10 LEADING:3 TRAILING:3 SLIDINGWINDOW:4:15 MINLEN:25

java -jar Trimmomatic-0.39/trimmomatic-0.39.jar PE -threads 8 -phred33 fastq/SRX7918795_1.fq.gz fastq/SRX7918795_2.fq.gz trimmed/SRX7918795_1.fq trimmed/SRX7918795_1_unpaired.fq trimmed/SRX7918795_2.fq trimmed/SRX7918795_2_unpaired.fq ILLUMINACLIP:Trimmomatic-0.39/adapters/adapters.fa:2:30:10 LEADING:3 TRAILING:3 SLIDINGWINDOW:4:15 MINLEN:25

java -jar Trimmomatic-0.39/trimmomatic-0.39.jar PE -threads 8 -phred33 fastq/ctcf-KD-rep1_1.fq.gz fastq/ctcf-KD-rep1_2.fq.gz trimmed/ctcf-KD-rep1_1.fq trimmed/ctcf-KD-rep1_1_unpaired.fq trimmed/ctcf-KD-rep1_2.fq trimmed/ctcf-KD-rep1_2_unpaired.fq ILLUMINACLIP:Trimmomatic-0.39/adapters/adapters.fa:2:30:10 LEADING:3 TRAILING:3 SLIDINGWINDOW:4:15 MINLEN:25

java -jar Trimmomatic-0.39/trimmomatic-0.39.jar PE -threads 8 -phred33 fastq/ctcf-KD-rep2_1.fq.gz fastq/ctcf-KD-rep2_2.fq.gz trimmed/ctcf-KD-rep2_1.fq trimmed/ctcf-KD-rep2_1_unpaired.fq trimmed/ctcf-KD-rep2_2.fq trimmed/ctcf-KD-rep2_2_unpaired.fq ILLUMINACLIP:Trimmomatic-0.39/adapters/adapters.fa:2:30:10 LEADING:3 TRAILING:3 SLIDINGWINDOW:4:15 MINLEN:25
#Input Read Pairs: 19503749 Both Surviving: 18516902 (94.94%) Forward Only Surviving: 843290 (4.32%) Reverse Only Surviving: 99901 (0.51%) Dropped: 43656 (0.22%)

java -jar Trimmomatic-0.39/trimmomatic-0.39.jar PE -threads 8 -phred33 fastq/ctcf-KD-rep3_1.fq.gz fastq/ctcf-KD-rep3_2.fq.gz trimmed/ctcf-KD-rep3_1.fq trimmed/ctcf-KD-rep3_1_unpaired.fq trimmed/ctcf-KD-rep3_2.fq trimmed/ctcf-KD-rep3_2_unpaired.fq ILLUMINACLIP:Trimmomatic-0.39/adapters/adapters.fa:2:30:10 LEADING:3 TRAILING:3 SLIDINGWINDOW:4:15 MINLEN:25

cd trimmed
mkdir -p unpaired
mv *unpaired.fq unpaired/
fastqc *.fq
mkdir -p fastqc
mv *.zip fastqc/
mv *.html fastqc/

cd ..

################################################################################
# Alignement with TopHat2 and Bowtie2
################################################################################
#TopHat(v2.1.2) Bowtie2(v2.3.4.1)
tophat2 -p 8 -o SRX7918784_tophat -G ~/genomes//Drosophila_melanogaster/UCSC/dm6/Annotation/Genes/genes.gtf ~/genomes//Bowtie2Indexes/dm6 trimmed/SRX7918784_1.fq trimmed/SRX7918784_2.fq
tophat2 -p 8 -o SRX7918785_tophat -G ~/genomes//Drosophila_melanogaster/UCSC/dm6/Annotation/Genes/genes.gtf ~/genomes//Bowtie2Indexes/dm6 trimmed/SRX7918785_1.fq trimmed/SRX7918785_2.fq
tophat2 -p 8 -o SRX7918786_tophat -G ~/genomes//Drosophila_melanogaster/UCSC/dm6/Annotation/Genes/genes.gtf ~/genomes//Bowtie2Indexes/dm6 trimmed/SRX7918786_1.fq trimmed/SRX7918786_2.fq

tophat2 -p 8 -o SRX7918787_tophat -G ~/genomes//Drosophila_melanogaster/UCSC/dm6/Annotation/Genes/genes.gtf ~/genomes//Bowtie2Indexes/dm6 trimmed/SRX7918787_1.fq trimmed/SRX7918787_2.fq
tophat2 -p 8 -o SRX7918788_tophat -G ~/genomes//Drosophila_melanogaster/UCSC/dm6/Annotation/Genes/genes.gtf ~/genomes//Bowtie2Indexes/dm6 trimmed/SRX7918787_1.fq trimmed/SRX7918788_2.fq
tophat2 -p 8 -o SRX7918789_tophat -G ~/genomes//Drosophila_melanogaster/UCSC/dm6/Annotation/Genes/genes.gtf ~/genomes//Bowtie2Indexes/dm6 trimmed/SRX7918789_1.fq trimmed/SRX7918789_2.fq

tophat2 -p 8 -o SRX7918790_tophat -G ~/genomes//Drosophila_melanogaster/UCSC/dm6/Annotation/Genes/genes.gtf ~/genomes//Bowtie2Indexes/dm6 trimmed/SRX7918790_1.fq trimmed/SRX7918790_2.fq
tophat2 -p 8 -o SRX7918791_tophat -G ~/genomes//Drosophila_melanogaster/UCSC/dm6/Annotation/Genes/genes.gtf ~/genomes//Bowtie2Indexes/dm6 trimmed/SRX7918790_1.fq trimmed/SRX7918791_2.fq
tophat2 -p 8 -o SRX7918792_tophat -G ~/genomes//Drosophila_melanogaster/UCSC/dm6/Annotation/Genes/genes.gtf ~/genomes//Bowtie2Indexes/dm6 trimmed/SRX7918792_1.fq trimmed/SRX7918792_2.fq

tophat2 -p 8 -o SRX7918793_tophat -G ~/genomes//Drosophila_melanogaster/UCSC/dm6/Annotation/Genes/genes.gtf ~/genomes//Bowtie2Indexes/dm6 trimmed/SRX7918793_1.fq trimmed/SRX7918793_2.fq
tophat2 -p 8 -o SRX7918794_tophat -G ~/genomes//Drosophila_melanogaster/UCSC/dm6/Annotation/Genes/genes.gtf ~/genomes//Bowtie2Indexes/dm6 trimmed/SRX7918793_1.fq trimmed/SRX7918794_2.fq
tophat2 -p 8 -o SRX7918795_tophat -G ~/genomes//Drosophila_melanogaster/UCSC/dm6/Annotation/Genes/genes.gtf ~/genomes//Bowtie2Indexes/dm6 trimmed/SRX7918795_1.fq trimmed/SRX7918795_2.fq

tophat2 -p 8 -o ctcf-KD-rep1_tophat -G ~/genomes//Drosophila_melanogaster/UCSC/dm6/Annotation/Genes/genes.gtf ~/genomes//Bowtie2Indexes/dm6 trimmed/ctcf-KD-rep1_1.fq trimmed/ctcf-KD-rep1_2.fq
tophat2 -p 8 -o ctcf-KD-rep2_tophat -G ~/genomes//Drosophila_melanogaster/UCSC/dm6/Annotation/Genes/genes.gtf ~/genomes//Bowtie2Indexes/dm6 trimmed/ctcf-KD-rep1_1.fq trimmed/ctcf-KD-rep2_2.fq
tophat2 -p 8 -o ctcf-KD-rep3_tophat -G ~/genomes//Drosophila_melanogaster/UCSC/dm6/Annotation/Genes/genes.gtf ~/genomes//Bowtie2Indexes/dm6 trimmed/ctcf-KD-rep3_1.fq trimmed/ctcf-KD-rep3_2.fq


mkdir -p bam
mv *.bam bam/

samtools sort -o bam/WT_rep1_sorted.bam SRX7918784_tophat/accepted_hits.bam
samtools sort -o bam/WT_rep2_sorted.bam SRX7918785_tophat/accepted_hits.bam
samtools sort -o bam/WT_rep3_sorted.bam SRX7918786_tophat/accepted_hits.bam

samtools sort -o bam/BEAF32_KD_rep1_sorted.bam SRX7918787_tophat/accepted_hits.bam
samtools sort -o bam/BEAF32_KD_rep2_sorted.bam SRX7918788_tophat/accepted_hits.bam
samtools sort -o bam/BEAF32_KD_rep3_sorted.bam SRX7918789_tophat/accepted_hits.bam

samtools sort -o bam/Cp190_Chrom_KD_rep1_sorted.bam SRX7918790_tophat/accepted_hits.bam
samtools sort -o bam/Cp190_Chrom_KD_rep2_sorted.bam SRX7918791_tophat/accepted_hits.bam
samtools sort -o bam/Cp190_Chrom_KD_rep3_sorted.bam SRX7918792_tophat/accepted_hits.bam

samtools sort -o bam/BEAF32_DREF_KD_rep1_sorted.bam SRX7918793_tophat/accepted_hits.bam
samtools sort -o bam/BEAF32_DREF_KD_rep2_sorted.bam SRX7918794_tophat/accepted_hits.bam
samtools sort -o bam/BEAF32_DREF_KD_rep3_sorted.bam SRX7918795_tophat/accepted_hits.bam

samtools sort -o bam/CTCF_KD_rep1_sorted.bam ctcf-KD-rep1_tophat/accepted_hits.bam
samtools sort -o bam/CTCF_KD_rep2_sorted.bam ctcf-KD-rep2_tophat/accepted_hits.bam
samtools sort -o bam/CTCF_KD_rep3_sorted.bam ctcf-KD-rep3_tophat/accepted_hits.bam

################################################################################
# deduplication with picard https://broadinstitute.github.io/picard/
################################################################################

java -Xmx4g -jar picard.jar MarkDuplicates I=bam/WT_rep1_sorted.bam O=bam/WT_rep1_sorted_deduplicated.bam M=bam/WT_rep1_sorted_deduplicated_metrics.txt VALIDATION_STRINGENCY=LENIENT REMOVE_DUPLICATES=true

java -Xmx4g -jar picard.jar MarkDuplicates I=bam/WT_rep2_sorted.bam O=bam/WT_rep2_sorted_deduplicated.bam M=bam/WT_rep2_sorted_deduplicated_metrics.txt VALIDATION_STRINGENCY=LENIENT REMOVE_DUPLICATES=true

java -Xmx4g -jar picard.jar MarkDuplicates I=bam/WT_rep3_sorted.bam O=bam/WT_rep3_sorted_deduplicated.bam M=bam/WT_rep3_sorted_deduplicated_metrics.txt VALIDATION_STRINGENCY=LENIENT REMOVE_DUPLICATES=true

java -Xmx4g -jar picard.jar MarkDuplicates I=bam/BEAF32_KD_rep1_sorted.bam O=bam/BEAF32_KD_rep1_sorted_deduplicated.bam M=bam/BEAF32_KD_rep1_sorted_deduplicated_metrics.txt VALIDATION_STRINGENCY=LENIENT REMOVE_DUPLICATES=true

java -Xmx4g -jar picard.jar MarkDuplicates I=bam/BEAF32_KD_rep2_sorted.bam O=bam/BEAF32_KD_rep2_sorted_deduplicated.bam M=bam/BEAF32_KD_rep2_sorted_deduplicated_metrics.txt VALIDATION_STRINGENCY=LENIENT REMOVE_DUPLICATES=true

java -Xmx4g -jar picard.jar MarkDuplicates I=bam/BEAF32_KD_rep3_sorted.bam O=bam/BEAF32_KD_rep3_sorted_deduplicated.bam M=bam/BEAF32_KD_rep3_sorted_deduplicated_metrics.txt VALIDATION_STRINGENCY=LENIENT REMOVE_DUPLICATES=true

java -Xmx4g -jar picard.jar MarkDuplicates I=bam/Cp190_Chrom_KD_rep1_sorted.bam O=bam/Cp190_Chrom_KD_rep1_sorted_deduplicated.bam M=bam/Cp190_Chrom_KD_rep1_sorted_deduplicated_metrics.txt VALIDATION_STRINGENCY=LENIENT REMOVE_DUPLICATES=true

java -Xmx4g -jar picard.jar MarkDuplicates I=bam/Cp190_Chrom_KD_rep2_sorted.bam O=bam/Cp190_Chrom_KD_rep2_sorted_deduplicated.bam M=bam/Cp190_Chrom_KD_rep2_sorted_deduplicated_metrics.txt VALIDATION_STRINGENCY=LENIENT REMOVE_DUPLICATES=true

java -Xmx4g -jar picard.jar MarkDuplicates I=bam/Cp190_Chrom_KD_rep3_sorted.bam O=bam/Cp190_Chrom_KD_rep3_sorted_deduplicated.bam M=bam/Cp190_Chrom_KD_rep3_sorted_deduplicated_metrics.txt VALIDATION_STRINGENCY=LENIENT REMOVE_DUPLICATES=true

java -Xmx4g -jar picard.jar MarkDuplicates I=bam/BEAF32_DREF_KD_rep1_sorted.bam O=bam/BEAF32_DREF_KD_rep1_sorted_deduplicated.bam M=bam/BEAF32_DREF_KD_rep1_sorted_deduplicated_metrics.txt VALIDATION_STRINGENCY=LENIENT REMOVE_DUPLICATES=true

java -Xmx4g -jar picard.jar MarkDuplicates I=bam/BEAF32_DREF_KD_rep2_sorted.bam O=bam/BEAF32_DREF_KD_rep2_sorted_deduplicated.bam M=bam/BEAF32_DREF_KD_rep2_sorted_deduplicated_metrics.txt VALIDATION_STRINGENCY=LENIENT REMOVE_DUPLICATES=true

java -Xmx4g -jar picard.jar MarkDuplicates I=bam/BEAF32_DREF_KD_rep3_sorted.bam O=bam/BEAF32_DREF_KD_rep3_sorted_deduplicated.bam M=bam/BEAF32_DREF_KD_rep3_sorted_deduplicated_metrics.txt VALIDATION_STRINGENCY=LENIENT REMOVE_DUPLICATES=true


java -Xmx4g -jar picard.jar MarkDuplicates I=bam/CTCF_KD_rep1_sorted.bam O=bam/CTCF_KD_rep1_sorted_deduplicated.bam M=bam/CTCF_KD_rep1_sorted_deduplicated_metrics.txt VALIDATION_STRINGENCY=LENIENT REMOVE_DUPLICATES=true

java -Xmx4g -jar picard.jar MarkDuplicates I=bam/CTCF_KD_rep2_sorted.bam O=bam/CTCF_KD_rep2_sorted_deduplicated.bam M=bam/CTCF_KD_rep2_sorted_deduplicated_metrics.txt VALIDATION_STRINGENCY=LENIENT REMOVE_DUPLICATES=true

java -Xmx4g -jar picard.jar MarkDuplicates I=bam/CTCF_KD_rep3_sorted.bam O=bam/CTCF_KD_rep3_sorted_deduplicated.bam M=bam/CTCF_KD_rep3_sorted_deduplicated_metrics.txt VALIDATION_STRINGENCY=LENIENT REMOVE_DUPLICATES=true



cd  bam
samtools index *deduplicated.bam

cd ..

################################################################################
# HTseq count
################################################################################
mkdir -p htseq
htseq-count -f bam bam/WT_rep1_sorted_deduplicated.bam ~/genomes//Drosophila_melanogaster/UCSC/dm6/Annotation/Genes/genes.gtf > htseq/WT_rep1.txt
htseq-count -f bam bam/WT_rep2_sorted_deduplicated.bam ~/genomes//Drosophila_melanogaster/UCSC/dm6/Annotation/Genes/genes.gtf > htseq/WT_rep2.txt
htseq-count -f bam bam/WT_rep3_sorted_deduplicated.bam ~/genomes//Drosophila_melanogaster/UCSC/dm6/Annotation/Genes/genes.gtf > htseq/WT_rep3.txt

htseq-count -f bam bam/BEAF32_KD_rep1_sorted_deduplicated.bam ~/genomes//Drosophila_melanogaster/UCSC/dm6/Annotation/Genes/genes.gtf > htseq/BEAF32_KD_rep1.txt
htseq-count -f bam bam/BEAF32_KD_rep2_sorted_deduplicated.bam ~/genomes//Drosophila_melanogaster/UCSC/dm6/Annotation/Genes/genes.gtf > htseq/BEAF32_KD_rep2.txt
htseq-count -f bam bam/BEAF32_KD_rep3_sorted_deduplicated.bam ~/genomes//Drosophila_melanogaster/UCSC/dm6/Annotation/Genes/genes.gtf > htseq/BEAF32_KD_rep3.txt


htseq-count -f bam bam/Cp190_Chrom_KD_rep1_sorted_deduplicated.bam ~/genomes//Drosophila_melanogaster/UCSC/dm6/Annotation/Genes/genes.gtf > htseq/Cp190_Chrom_KD_rep1.txt
htseq-count -f bam bam/Cp190_Chrom_KD_rep2_sorted_deduplicated.bam ~/genomes//Drosophila_melanogaster/UCSC/dm6/Annotation/Genes/genes.gtf > htseq/Cp190_Chrom_KD_rep2.txt
htseq-count -f bam bam/Cp190_Chrom_KD_rep3_sorted_deduplicated.bam ~/genomes//Drosophila_melanogaster/UCSC/dm6/Annotation/Genes/genes.gtf > htseq/Cp190_Chrom_KD_rep3.txt


htseq-count -f bam bam/BEAF32_DREF_KD_rep1_sorted_deduplicated.bam ~/genomes//Drosophila_melanogaster/UCSC/dm6/Annotation/Genes/genes.gtf > htseq/BEAF32_DREF_KD_rep1.txt
htseq-count -f bam bam/BEAF32_DREF_KD_rep2_sorted_deduplicated.bam ~/genomes//Drosophila_melanogaster/UCSC/dm6/Annotation/Genes/genes.gtf > htseq/BEAF32_DREF_KD_rep2.txt
htseq-count -f bam bam/BEAF32_DREF_KD_rep3_sorted_deduplicated.bam ~/genomes//Drosophila_melanogaster/UCSC/dm6/Annotation/Genes/genes.gtf > htseq/BEAF32_DREF_KD_rep3.txt

htseq-count -f bam bam/CTCF_KD_rep1_sorted_deduplicated.bam ~/genomes//Drosophila_melanogaster/UCSC/dm6/Annotation/Genes/genes.gtf > htseq/CTCF_KD_rep1.txt
htseq-count -f bam bam/CTCF_KD_rep2_sorted_deduplicated.bam ~/genomes//Drosophila_melanogaster/UCSC/dm6/Annotation/Genes/genes.gtf > htseq/CTCF_KD_rep2.txt
htseq-count -f bam bam/CTCF_KD_rep3_sorted_deduplicated.bam ~/genomes//Drosophila_melanogaster/UCSC/dm6/Annotation/Genes/genes.gtf > htseq/CTCF_KD_rep3.txt


################################################################################
# BigWig profiles
################################################################################
samtools index SRX7918784_tophat/accepted_hits.bam
bamCoverage -b SRX7918784_tophat/accepted_hits.bam -o WT_rep1.bw

samtools index SRX7918785_tophat/accepted_hits.bam
bamCoverage -b SRX7918785_tophat/accepted_hits.bam -o WT_rep2.bw

samtools index SRX7918786_tophat/accepted_hits.bam
bamCoverage -b SRX7918786_tophat/accepted_hits.bam -o WT_rep3.bw


samtools index SRX7918787_tophat/accepted_hits.bam
bamCoverage -b SRX7918787_tophat/accepted_hits.bam -o BEAF32_KD_rep1.bw

samtools index SRX7918788_tophat/accepted_hits.bam
bamCoverage -b SRX7918788_tophat/accepted_hits.bam -o BEAF32_KD_rep2.bw

samtools index SRX7918789_tophat/accepted_hits.bam
bamCoverage -b SRX7918789_tophat/accepted_hits.bam -o BEAF32_KD_rep3.bw

samtools index SRX7918790_tophat/accepted_hits.bam
bamCoverage -b SRX7918790_tophat/accepted_hits.bam -o Cp190_Chrom_KD_rep1.bw

samtools index SRX7918791_tophat/accepted_hits.bam
bamCoverage -b SRX7918791_tophat/accepted_hits.bam -o Cp190_Chrom_KD_rep2.bw

samtools index SRX7918792_tophat/accepted_hits.bam
bamCoverage -b SRX7918792_tophat/accepted_hits.bam -o Cp190_Chrom_KD_rep3.bw

samtools index SRX7918793_tophat/accepted_hits.bam
bamCoverage -b SRX7918793_tophat/accepted_hits.bam -o BEAF32_DREF_KD_rep1.bw

samtools index SRX7918794_tophat/accepted_hits.bam
bamCoverage -b SRX7918794_tophat/accepted_hits.bam -o BEAF32_DREF_KD_rep2.bw

samtools index SRX7918795_tophat/accepted_hits.bam
bamCoverage -b SRX7918795_tophat/accepted_hits.bam -o BEAF32_DREF_KD_rep3.bw

samtools index ctcf-KD-rep1_tophat/accepted_hits.bam
bamCoverage -b ctcf-KD-rep1_tophat/accepted_hits.bam -o CTCF_KD_rep1.bw

samtools index ctcf-KD-rep2_tophat/accepted_hits.bam
bamCoverage -b ctcf-KD-rep2_tophat/accepted_hits.bam -o CTCF_KD_rep2.bw

samtools index ctcf-KD-rep3_tophat/accepted_hits.bam
bamCoverage -b ctcf-KD-rep3_tophat/accepted_hits.bam -o CTCF_KD_rep3.bw



samtools merge WT_tophat.bam SRX7918784_tophat/accepted_hits.bam SRX7918785_tophat/accepted_hits.bam SRX7918786_tophat/accepted_hits.bam
samtools sort -o WT_tophat_sorted.bam WT_tophat.bam
samtools index WT_tophat_sorted.bam
bamCoverage -b WT_tophat_sorted.bam -o WT_RNAseq.bw


samtools merge BEAF32_KD_tophat.bam SRX7918787_tophat/accepted_hits.bam SRX7918788_tophat/accepted_hits.bam SRX7918789_tophat/accepted_hits.bam
samtools sort -o BEAF32_KD_tophat_sorted.bam BEAF32_KD_tophat.bam
samtools index BEAF32_KD_tophat_sorted.bam
bamCoverage -b BEAF32_KD_tophat_sorted.bam -o BEAF32_KD_RNAseq.bw


samtools merge Cp190_Chrom_KD_tophat.bam SRX7918790_tophat/accepted_hits.bam SRX7918791_tophat/accepted_hits.bam SRX7918792_tophat/accepted_hits.bam
samtools sort -o Cp190_Chrom_KD_tophat_sorted.bam Cp190_Chrom_KD_tophat.bam
samtools index Cp190_Chrom_KD_tophat_sorted.bam
bamCoverage -b Cp190_Chrom_KD_tophat_sorted.bam -o Cp190_Chrom_KD_RNAseq.bw


samtools merge BEAF32_DREF_KD_tophat.bam SRX7918793_tophat/accepted_hits.bam SRX7918794_tophat/accepted_hits.bam SRX7918795_tophat/accepted_hits.bam
samtools sort -o BEAF32_DREF_KD_tophat_sorted.bam BEAF32_DREF_KD_tophat.bam
samtools index BEAF32_DREF_KD_tophat_sorted.bam
bamCoverage -b BEAF32_DREF_KD_tophat_sorted.bam -o BEAF32_DREF_KD_RNAseq.bw


samtools merge CTCF_KD_tophat.bam ctcf-KD-rep1_tophat/accepted_hits.bam ctcf-KD-rep2_tophat/accepted_hits.bam ctcf-KD-rep3_tophat/accepted_hits.bam
samtools sort -o CTCF_KD_tophat_sorted.bam CTCF_KD_tophat.bam
samtools index CTCF_KD_tophat_sorted.bam
bamCoverage -b CTCF_KD_tophat_sorted.bam -o CTCF_KD_RNAseq.bw
