#!/bin/bash

#Jill E. Moore
#Weng Lab
#UMass Medical School
#January 2021

peaks=$1
files=$2
outputDir=$3
j=$SLURM_ARRAY_TASK_ID

dataDir=/data/zusers/zhangx/projects/rampage/0_rampage_peak/bw/
scriptDir=~/GitHub/RAMPAGE-Analysis/rPeak-Pipeline

exp=$(awk -F "\t" '{if (NR=='$j') print $1}' $files)
bigWigP=$dataDir/$exp"_rampage_plus.bw"
bigWigM=$dataDir/$exp"_rampage_minus.bw"

mkdir -p /tmp/moorej3/$SLURM_JOBID"-"$j
cd /tmp/moorej3/$SLURM_JOBID"-"$j

/bin/sleep   `/usr/bin/expr $RANDOM % 60`

awk '{if ($6 == "+") print $1 "\t" $2 "\t" $3 "\t" $4}' $peaks > plus
awk '{if ($6 == "-") print $1 "\t" $2 "\t" $3 "\t" $4}' $peaks > minus

~/bin/bigWigAverageOverBed $bigWigP plus plus.tab
~/bin/bigWigAverageOverBed $bigWigM minus minus.tab

depth=$(grep $exp $scriptDir/RAMPAGE-RNA-Match-List.txt | awk '{print $2}')

cat plus.tab minus.tab | awk '{print $1 "\t" ($4/'$depth'*1000000)/($2/1000) \
    "\t" $4 "\t" "'$depth'" "\t" ($4/'$depth'*1000000)}' | sort -k1,1 > $outputDir/$exp.txt

cd /home/moorej3/
rm -r /tmp/moorej3/$SLURM_JOBID"-"$j
