program mainprogram


implicit none

include 'global.var'

integer ::ni,i,j,k,a,b,v,ip,jp,kp,time,ii,L2,s,ll
real    ::x,y,z,xp,yp,zp,x0,y0,z0,Eint0
character(len=128) :: fname1,fname2,fname3
real*8  ::randomnumber

open(10,file='seed.out')
read(10,*) i
close(10)
!initialize random generator
call SYSTEM_CLOCK(time)
call srand(time+10*i)
call initializerandomnumbergenerator(dble(rand()))



!load input
open(10,file='input.dat')
read(10,*) Nchain !chain size
read(10,*) L !box size L
read(10,*) Niter !number of iterations
read(10,*) Neq   !number of equilibrium moves
read(10,*) Nmeas !number of measures
read(10,*) Ninter!interval between measures
read(10,*) kint !bending energy
read(10,*) NTAD !number of TADs
read(10,*) NLoop !number of loops
read(10,*) ETADA !energy of interaction between intra-TAD monomers in A compartment 
read(10,*) ETADB !energy of interaction between intra-TAD monomers in B compartment
read(10,*) ELoop !energy of interaction between Loop states
read(10,*) EAA !energy of interaction between A and A  compartments
read(10,*) EBB !energy of interaction between B and B  compartments
read(10,*) EAB !energy of interaction between A and B  compartments
close(10)

!load the TAD state of monomers
call state_create()

!load the compartment state of monomers
open(10,file='compartement.out')
read(10,*) compartement
close(10)

!load the Loop state of monomers
open(10,file='Loop.out')
read(10,*) Loop
close(10)

!load files
opp(1)=1
do i=1,6
    opp(2*i)=2*i+1
    opp(2*i+1)=2*i
end do
open(15,file='voisxyz.out')
open(16,file='costhet.out')
open(17,file='voisnn.out')
do i=1,13
    read(16,*) costhet(i,:)
    do j=1,13
        read(17,*) voisnn(:,i,j)
    end do
    read(15,*) voisxyz(:,i)
end do
close(15)
close(16)
close(17)
costhet=costhet*kint
x=0.
do i=2,13
    do j=2,13
        x=x+exp(-costhet(i,j))
    end do
end do
x=-log(x/real(12*12))
do i=1,13
    costhet(1,i)=x;
    costhet(i,1)=x;
end do

!initialize bittable
bittable=0
L2=L*L
do a=1,4*L2*L
    k=int((a-1)/(2*L2))+1
    j=int((a-1)/L-2*L*(k-1))+1
    i=a-L*(2*L*(k-1)+(j-1))
    x=(i-1)+0.5*(1-mod(j+mod(k+1,2),2))
    y=(j-1)*0.5
    z=(k-1)*0.5
    bittable(1,a)=0
    do v=1,12
        xp=x+voisxyz(1,v+1)
        yp=y+voisxyz(2,v+1)
        zp=z+voisxyz(3,v+1)
        if (xp.ge.L) xp=xp-L
        if (xp.lt.0) xp=xp+L
        if (yp.ge.L) yp=yp-L
        if (yp.lt.0) yp=yp+L
        if (zp.ge.L) zp=zp-L
        if (zp.lt.0) zp=zp+L
        ip=int(xp)+1
        jp=int(2*yp+1)
        kp=int(2*zp+1)
        bittable(v+1,a)=ip+(jp-1)*L+(kp-1)*2*L2
    end do
end do
write(*,*) 'lattice density:',real(Nchain)/real(4*L2*L)


open(11,file='config.out')
open(12,file='dr.out')

do i=1,Niter

    !generate initial configuration
    call initconfig4()

    do j=1,Nchain
        s=compartement(j)+13
        if (s.gt.13) then
            a=config(1,j)
            bittable(s,a)=bittable(s,a)+1
            do k=2,13
                b=bittable(k,a)
                bittable(s,b)=bittable(s,b)+1
            end do
        end if
     end do

     do j=1,Nchain
        s=state(j)+15
        if (s.gt.15) then
           a=config(1,j)
           bittable(s,a)=bittable(s,a)+1
           do k=2,13
              b=bittable(k,a)
              bittable(s,b)=bittable(s,b)+1
           end do
        end if
     end do

     do j=1,Nchain
        s=Loop(j)+15+NTAD
        if (s.gt.15+NTAD) then
           a=config(1,j)
           bittable(s,a)=bittable(s,a)+1
           do k=2,13
              b=bittable(k,a)
              bittable(s,b)=bittable(s,b)+1
           end do
        end if
     end do
     
     dr=0.

    !equilibrium moves
    do j=1,Neq
       do v=1,Nchain
          call trialmovetad()
       end do
    end do
    
    !make measures
    call output()
    do j=1,Nmeas
       do k=1,Ninter
          do v=1,Nchain
             call trialmovetad()
          end do
       end do
       call output()
    end do
    call erase()
end do
close(11)
close(12)

end program
