#!/bin/bash

sm1=chr${1}_Dad.padprobe_sites
sm2=chr${1}_Mom.padprobe_sites
sm3=chr${1}_Kid.padprobe_sites

for i in Dad Mom Kid
do
bcftools view /PATH/TO/VCF/${i}.padprobe_sites.vcf.gz -t chr${1} > /PATH/TO/VCF/chr${1}_${i}.padprobe_sites.vcf
bgzip /PATH/TO/VCF/chr${1}_${i}.padprobe_sites.vcf
tabix -p vcf /PATH/TO/VCF/chr${1}_${i}.padprobe_sites.vcf.gz
done

bcftools merge --force-samples -O v /PATH/TO/VCF/$sm1.vcf.gz /PATH/TO/VCF/$sm2.vcf.gz /PATH/TO/VCF/$sm3.vcf.gz > /PATH/TO/VCF/all.vcf

perl p1.pl all
perl getinfoMom.pl all.fAA 
perl getinfoDad.pl all.fAA
perl getinfoKid.pl all.fAA
perl merge.pl

perl merge2.pl 
perl 2*.pl
perl 3*.pl
perl 4*.pl
perl 5*.pl >> /PATH/TO/HAPLOTYPE/FILE/chr$1.haplo


