#! /bin/bash

##################SNP calling

samtools view -h /PATH/TO/SAM/output.sorted.q15.bam| perl xm4.pl | perl xs10.pl > /PATH/TO/SAM/output.realigned.sam

samtools view -b /PATH/TO/SAM/output.realigned.sam > /PATH/TO/SAM/output.realigned.bam

java -Djava.awt.headless=true -Djava.io.tmpdir=/PATH/TO/TMP -Xmx40g -jar /PATH/TO/GATK/GenomeAnalysisTK.jar -T UnifiedGenotyper -glm BOTH -R /PATH/TO/REFERENCE/genome.fa -I /PATH/TO/SAM/output.realigned.bam -dcov 10000 --output_mode EMIT_ALL_SITES -S SILENT -nt 2 -nct 3 -l INFO -mbq 20 -rf BadCigar -o /PATH/TO/VCF/output.padprobe_sites.vcf

bgzip /PATH/TO/VCF/output.padprobe_sites.vcf
tabix -p vcf /PATH/TO/VCF/output.padprobe_sites.vcf.gz
