#!/usr/bin/perl
###############################################################################
# 
# Author: HeChen
# 
###############################################################################

use strict;
use warnings;

###############################################################################

#my $g  = 'hg38';
#my $fa = "/PATH/TO/REFERENCE/$g/$g.fa";

my ( $i5ref, $i7ref ) = &index;
my %i5 = %$i5ref;
my %i7 = %$i7ref;

my %Aindex = ();
my %Fbam   = ();
my $NAMEi  = &xname;
my %NAME   = %$NAMEi;

foreach my $i7 ( keys %i7 )
{
	foreach my $i5 ( keys %i5 )
	{
		my $i5_rc = join '', (reverse split //, $i5{$i5}); $i5_rc =~ tr/ATCG/TAGC/;
#		my $name = "${i7}rc$i5";
		my $iname = "${i7}rc$i5";
        my $name = '';
        if ( exists $NAME{$iname} )
        {
            $name = $NAME{$iname};
        }
        else
        {
#            warn "Not exists INDEX:$iname\n";
#            $name = "${i7}rc$i5";
            next;
        }

        # linux: ulimit -a
        # linux: ulimit -n 2048
		my $FILE1; open $FILE1, '>', "$name.sam" or die "Can't open $name.sam! $!\n";
#		my $FILE1; open $FILE1, "| samtools view -bT $fa >$name.bam" or die "Can't open $name.bam!\n";
		my %hash = 
		(
#			'Uniq' => 0,
#			'Muti' => 0,
			'Xmap' => 0,
			'Nmap' => 0,
		);
		my @files = ($FILE1, \%hash);

		$Aindex{"$i7{$i7}+$i5_rc"} = $name;
		$Fbam{"$i7{$i7}+$i5_rc"} = \@files;
	}
}

###############################################################################

my $total = 0;
my $reads = 0;

while ( my $line = <> )
{
	$total++;
	my @line = split /\s+/, $line;
	$line[1] =~ m/\d:N:\d:(.*)/o;
	my $barcode = $1;
	next, unless ( exists $Aindex{$barcode} );
	$reads++;

	if ( $line[3] eq '*' )
	{
		$Fbam{$barcode}->[1]->{'Nmap'}++;
	}
	else
	{
		$line = join "\t", ($line[0], @line[2..$#line]);
		print { $Fbam{$barcode}->[0] } $line,  "\n";
		$Fbam{$barcode}->[1]->{'Xmap'}++;
	}
}

map { close $Fbam{$_}->[0] } keys %Fbam; 
#map { close $Fbam{$_}->[0], close $Fbam{$_}->[1] } keys %Fbam; 

printf 'Sample reads: %.2f', $reads/$total; print "\n\n";


foreach my $barcode ( sort keys %Fbam )
{
#	print $barcode, ":\n";
	print $Aindex{$barcode}, "\n";
	print "\tXmap:\t", $Fbam{$barcode}->[1]->{'Xmap'}, "\n";
	print "\tNmap:\t", $Fbam{$barcode}->[1]->{'Nmap'}, "\n";
#	print "\tUniq:\t", $Fbam{$barcode}->[1]->{'Uniq'}, "\n";
#	print "\tMuti:\t", $Fbam{$barcode}->[1]->{'Muti'}, "\n";
	print "\n";
}


exit;


###############################################################################
###############################################################################
###############################################################################

sub index
{
	my %i8 = 
	(
	'N601' => 'CTCTCTAT',
	'N602' => 'TATCCTCT',
	'N603' => 'GTAAGGAG',
	'N604' => 'ACTGCATA',
	'N605' => 'AAGGAGTA',
	'N606' => 'CTAAGCCT',
	'N607' => 'CGTCTAAT',
	'N608' => 'TCTCTCCG',
	'N609' => 'TCGACTAG',
	'N610' => 'TTCTAGCT',
	'N611' => 'CCTAGAGT',
	'N612' => 'GCGTAAGA',

	'N801' => 'TAAGGCGA',
	'N802' => 'CGTACTAG',
	'N803' => 'AGGCAGAA',
	'N804' => 'TCCTGAGC',
	'N805' => 'GGACTCCT',
	'N806' => 'TAGGCATG',
	'N807' => 'CTCTCTAC',
	'N808' => 'CGAGGCTG',
	'N809' => 'AAGAGGCA',
	'N810' => 'GTAGAGGA',
	'N811' => 'GCTCATGA',
	'N812' => 'ATCTCAGG',
	'N813' => 'ACTCGCTA',
	'N814' => 'GGAGCTAC',
	'N815' => 'GCGTAGTA',
	'N816' => 'CGGAGCCT',
	'N817' => 'TACGCTGC',
	'N818' => 'ATGCGCAG',
	'N819' => 'TAGCGCTC',
	'N820' => 'ACTGAGCG',
#	'N821' => 'CCTAAGAC',
#	'N822' => 'CGATCAGT',
#	'N823' => 'TGCAGCTA',
#	'N824' => 'TCGACGTC',
	);

	my %i6 = 
	(
	'N601' => 'CTCTCTAT',
	'N602' => 'TATCCTCT',
	'N603' => 'GTAAGGAG',
	'N604' => 'ACTGCATA',
	'N605' => 'AAGGAGTA',
	'N606' => 'CTAAGCCT',
	'N607' => 'CGTCTAAT',
	'N608' => 'TCTCTCCG',
	'N609' => 'TCGACTAG',
	'N610' => 'TTCTAGCT',
	'N611' => 'CCTAGAGT',
	'N612' => 'GCGTAAGA',

#	'N613' => 'CTATTAAG',
#	'N614' => 'AAGGCTAT',
#	'N615' => 'GAGCCTTA',
#	'N616' => 'TTATGCGA',

	'N801' => 'TAAGGCGA',
	'N802' => 'CGTACTAG',
	'N803' => 'AGGCAGAA',
	'N804' => 'TCCTGAGC',
	'N805' => 'GGACTCCT',
	'N806' => 'TAGGCATG',
	'N807' => 'CTCTCTAC',
	'N808' => 'CGAGGCTG',
	'N809' => 'AAGAGGCA',
	'N810' => 'GTAGAGGA',
	'N811' => 'GCTCATGA',
	'N812' => 'ATCTCAGG',
	'N813' => 'ACTCGCTA',
	'N814' => 'GGAGCTAC',
	'N815' => 'GCGTAGTA',
	'N816' => 'CGGAGCCT',
	'N817' => 'TACGCTGC',
	'N818' => 'ATGCGCAG',
	'N819' => 'TAGCGCTC',
	'N820' => 'ACTGAGCG',
	);
	return \%i6, \%i8;
}

sub xname
{
    my %name = ( 
'N601rcN601' => 'P1A1',
'N601rcN602' => 'P1A2',
'N601rcN603' => 'P1A3',
'N601rcN604' => 'P1A4',
'N601rcN605' => 'P1A5',
'N601rcN606' => 'P1A6',
'N601rcN607' => 'P1A7',
'N601rcN608' => 'P1A8',
'N601rcN609' => 'P1A9',
'N601rcN610' => 'P1A10',
'N601rcN611' => 'P1A11',
'N601rcN612' => 'P1A12',
'N602rcN601' => 'P1B1',
'N602rcN602' => 'P1B2',
'N602rcN603' => 'P1B3',
'N602rcN604' => 'P1B4',
'N602rcN605' => 'P1B5',
'N602rcN606' => 'P1B6',
'N602rcN607' => 'P1B7',
'N602rcN608' => 'P1B8',
'N602rcN609' => 'P1B9',
'N602rcN610' => 'P1B10',
'N602rcN611' => 'P1B11',
'N602rcN612' => 'P1B12',
'N603rcN601' => 'P1C1',
'N603rcN602' => 'P1C2',
'N603rcN603' => 'P1C3',
'N603rcN604' => 'P1C4',
'N603rcN605' => 'P1C5',
'N603rcN606' => 'P1C6',
'N603rcN607' => 'P1C7',
'N603rcN608' => 'P1C8',
'N603rcN609' => 'P1C9',
'N603rcN610' => 'P1C10',
'N603rcN611' => 'P1C11',
'N603rcN612' => 'P1C12',
'N604rcN601' => 'P1D1',
'N604rcN602' => 'P1D2',
'N604rcN603' => 'P1D3',
'N604rcN604' => 'P1D4',
'N604rcN605' => 'P1D5',
'N604rcN606' => 'P1D6',
'N604rcN607' => 'P1D7',
'N604rcN608' => 'P1D8',
'N604rcN609' => 'P1D9',
'N604rcN610' => 'P1D10',
'N604rcN611' => 'P1D11',
'N604rcN612' => 'P1D12',
'N605rcN601' => 'P1E1',
'N605rcN602' => 'P1E2',
'N605rcN603' => 'P1E3',
'N605rcN604' => 'P1E4',
'N605rcN605' => 'P1E5',
'N605rcN606' => 'P1E6',
'N605rcN607' => 'P1E7',
'N605rcN608' => 'P1E8',
'N605rcN609' => 'P1E9',
'N605rcN610' => 'P1E10',
'N605rcN611' => 'P1E11',
'N605rcN612' => 'P1E12',
'N606rcN601' => 'P1F1',
'N606rcN602' => 'P1F2',
'N606rcN603' => 'P1F3',
'N606rcN604' => 'P1F4',
'N606rcN605' => 'P1F5',
'N606rcN606' => 'P1F6',
'N606rcN607' => 'P1F7',
'N606rcN608' => 'P1F8',
'N606rcN609' => 'P1F9',
'N606rcN610' => 'P1F10',
'N606rcN611' => 'P1F11',
'N606rcN612' => 'P1F12',
'N607rcN601' => 'P1G1',
'N607rcN602' => 'P1G2',
'N607rcN603' => 'P1G3',
'N607rcN604' => 'P1G4',
'N607rcN605' => 'P1G5',
'N607rcN606' => 'P1G6',
'N607rcN607' => 'P1G7',
'N607rcN608' => 'P1G8',
'N607rcN609' => 'P1G9',
'N607rcN610' => 'P1G10',
'N607rcN611' => 'P1G11',
'N607rcN612' => 'P1G12',
'N608rcN601' => 'P1H1',
'N608rcN602' => 'P1H2',
'N608rcN603' => 'P1H3',
'N608rcN604' => 'P1H4',
'N608rcN605' => 'P1H5',
'N608rcN606' => 'P1H6',
'N608rcN607' => 'P1H7',
'N608rcN608' => 'P1H8',
'N608rcN609' => 'P1H9',
'N608rcN610' => 'P1H10',
'N608rcN611' => 'P1H11',
'N608rcN612' => 'P1H12',
'N609rcN801' => 'P2A1',
'N609rcN802' => 'P2A2',
'N609rcN803' => 'P2A3',
'N609rcN804' => 'P2A4',
'N609rcN805' => 'P2A5',
'N609rcN806' => 'P2A6',
'N609rcN807' => 'P2A7',
'N609rcN808' => 'P2A8',
'N609rcN809' => 'P2A9',
'N609rcN810' => 'P2A10',
'N609rcN811' => 'P2A11',
'N609rcN812' => 'P2A12',
'N610rcN801' => 'P2B1',
'N610rcN802' => 'P2B2',
'N610rcN803' => 'P2B3',
'N610rcN804' => 'P2B4',
'N610rcN805' => 'P2B5',
'N610rcN806' => 'P2B6',
'N610rcN807' => 'P2B7',
'N610rcN808' => 'P2B8',
'N610rcN809' => 'P2B9',
'N610rcN810' => 'P2B10',
'N610rcN811' => 'P2B11',
'N610rcN812' => 'P2B12',
'N611rcN801' => 'P2C1',
'N611rcN802' => 'P2C2',
'N611rcN803' => 'P2C3',
'N611rcN804' => 'P2C4',
'N611rcN805' => 'P2C5',
'N611rcN806' => 'P2C6',
'N611rcN807' => 'P2C7',
'N611rcN808' => 'P2C8',
'N611rcN809' => 'P2C9',
'N611rcN810' => 'P2C10',
'N611rcN811' => 'P2C11',
'N611rcN812' => 'P2C12',
'N612rcN801' => 'P2D1',
'N612rcN802' => 'P2D2',
'N612rcN803' => 'P2D3',
'N612rcN804' => 'P2D4',
'N612rcN805' => 'P2D5',
'N612rcN806' => 'P2D6',
'N612rcN807' => 'P2D7',
'N612rcN808' => 'P2D8',
'N612rcN809' => 'P2D9',
'N612rcN810' => 'P2D10',
'N612rcN811' => 'P2D11',
'N612rcN812' => 'P2D12',
'N801rcN801' => 'P2E1',
'N801rcN802' => 'P2E2',
'N801rcN803' => 'P2E3',
'N801rcN804' => 'P2E4',
'N801rcN805' => 'P2E5',
'N801rcN806' => 'P2E6',
'N801rcN807' => 'P2E7',
'N801rcN808' => 'P2E8',
'N801rcN809' => 'P2E9',
'N801rcN810' => 'P2E10',
'N801rcN811' => 'P2E11',
'N801rcN812' => 'P2E12',
'N802rcN801' => 'P2F1',
'N802rcN802' => 'P2F2',
'N802rcN803' => 'P2F3',
'N802rcN804' => 'P2F4',
'N802rcN805' => 'P2F5',
'N802rcN806' => 'P2F6',
'N802rcN807' => 'P2F7',
'N802rcN808' => 'P2F8',
'N802rcN809' => 'P2F9',
'N802rcN810' => 'P2F10',
'N802rcN811' => 'P2F11',
'N802rcN812' => 'P2F12',
'N803rcN801' => 'P2G1',
'N803rcN802' => 'P2G2',
'N803rcN803' => 'P2G3',
'N803rcN804' => 'P2G4',
'N803rcN805' => 'P2G5',
'N803rcN806' => 'P2G6',
'N803rcN807' => 'P2G7',
'N803rcN808' => 'P2G8',
'N803rcN809' => 'P2G9',
'N803rcN810' => 'P2G10',
'N803rcN811' => 'P2G11',
'N803rcN812' => 'P2G12',
'N804rcN801' => 'P2H1',
'N804rcN802' => 'P2H2',
'N804rcN803' => 'P2H3',
'N804rcN804' => 'P2H4',
'N804rcN805' => 'P2H5',
'N804rcN806' => 'P2H6',
'N804rcN807' => 'P2H7',
'N804rcN808' => 'P2H8',
'N804rcN809' => 'P2H9',
'N804rcN810' => 'P2H10',
'N804rcN811' => 'P2H11',
'N804rcN812' => 'P2H12',
'N805rcN601' => 'P3A1',
'N805rcN602' => 'P3A2',
'N805rcN603' => 'P3A3',
'N805rcN604' => 'P3A4',
'N805rcN605' => 'P3A5',
'N805rcN606' => 'P3A6',
'N805rcN607' => 'P3A7',
'N805rcN608' => 'P3A8',
'N805rcN609' => 'P3A9',
'N805rcN610' => 'P3A10',
'N805rcN611' => 'P3A11',
'N805rcN612' => 'P3A12',
'N806rcN601' => 'P3B1',
'N806rcN602' => 'P3B2',
'N806rcN603' => 'P3B3',
'N806rcN604' => 'P3B4',
'N806rcN605' => 'P3B5',
'N806rcN606' => 'P3B6',
'N806rcN607' => 'P3B7',
'N806rcN608' => 'P3B8',
'N806rcN609' => 'P3B9',
'N806rcN610' => 'P3B10',
'N806rcN611' => 'P3B11',
'N806rcN612' => 'P3B12',
'N807rcN601' => 'P3C1',
'N807rcN602' => 'P3C2',
'N807rcN603' => 'P3C3',
'N807rcN604' => 'P3C4',
'N807rcN605' => 'P3C5',
'N807rcN606' => 'P3C6',
'N807rcN607' => 'P3C7',
'N807rcN608' => 'P3C8',
'N807rcN609' => 'P3C9',
'N807rcN610' => 'P3C10',
'N807rcN611' => 'P3C11',
'N807rcN612' => 'P3C12',
'N808rcN601' => 'P3D1',
'N808rcN602' => 'P3D2',
'N808rcN603' => 'P3D3',
'N808rcN604' => 'P3D4',
'N808rcN605' => 'P3D5',
'N808rcN606' => 'P3D6',
'N808rcN607' => 'P3D7',
'N808rcN608' => 'P3D8',
'N808rcN609' => 'P3D9',
'N808rcN610' => 'P3D10',
'N808rcN611' => 'P3D11',
'N808rcN612' => 'P3D12',
'N809rcN601' => 'P3E1',
'N809rcN602' => 'P3E2',
'N809rcN603' => 'P3E3',
'N809rcN604' => 'P3E4',
'N809rcN605' => 'P3E5',
'N809rcN606' => 'P3E6',
'N809rcN607' => 'P3E7',
'N809rcN608' => 'P3E8',
'N809rcN609' => 'P3E9',
'N809rcN610' => 'P3E10',
'N809rcN611' => 'P3E11',
'N809rcN612' => 'P3E12',
'N810rcN601' => 'P3F1',
'N810rcN602' => 'P3F2',
'N810rcN603' => 'P3F3',
'N810rcN604' => 'P3F4',
'N810rcN605' => 'P3F5',
'N810rcN606' => 'P3F6',
'N810rcN607' => 'P3F7',
'N810rcN608' => 'P3F8',
'N810rcN609' => 'P3F9',
'N810rcN610' => 'P3F10',
'N810rcN611' => 'P3F11',
'N810rcN612' => 'P3F12',
'N811rcN601' => 'P3G1',
'N811rcN602' => 'P3G2',
'N811rcN603' => 'P3G3',
'N811rcN604' => 'P3G4',
'N811rcN605' => 'P3G5',
'N811rcN606' => 'P3G6',
'N811rcN607' => 'P3G7',
'N811rcN608' => 'P3G8',
'N811rcN609' => 'P3G9',
'N811rcN610' => 'P3G10',
'N811rcN611' => 'P3G11',
'N811rcN612' => 'P3G12',
'N812rcN601' => 'P3H1',
'N812rcN602' => 'P3H2',
'N812rcN603' => 'P3H3',
'N812rcN604' => 'P3H4',
'N812rcN605' => 'P3H5',
'N812rcN606' => 'P3H6',
'N812rcN607' => 'P3H7',
'N812rcN608' => 'P3H8',
'N812rcN609' => 'P3H9',
'N812rcN610' => 'P3H10',
'N812rcN611' => 'P3H11',
'N812rcN612' => 'P3H12',
'N813rcN801' => 'P4A1',
'N813rcN802' => 'P4A2',
'N813rcN803' => 'P4A3',
'N813rcN804' => 'P4A4',
'N813rcN805' => 'P4A5',
'N813rcN806' => 'P4A6',
'N813rcN807' => 'P4A7',
'N813rcN808' => 'P4A8',
'N813rcN809' => 'P4A9',
'N813rcN810' => 'P4A10',
'N813rcN811' => 'P4A11',
'N813rcN812' => 'P4A12',
'N814rcN801' => 'P4B1',
'N814rcN802' => 'P4B2',
'N814rcN803' => 'P4B3',
'N814rcN804' => 'P4B4',
'N814rcN805' => 'P4B5',
'N814rcN806' => 'P4B6',
'N814rcN807' => 'P4B7',
'N814rcN808' => 'P4B8',
'N814rcN809' => 'P4B9',
'N814rcN810' => 'P4B10',
'N814rcN811' => 'P4B11',
'N814rcN812' => 'P4B12',
'N815rcN801' => 'P4C1',
'N815rcN802' => 'P4C2',
'N815rcN803' => 'P4C3',
'N815rcN804' => 'P4C4',
'N815rcN805' => 'P4C5',
'N815rcN806' => 'P4C6',
'N815rcN807' => 'P4C7',
'N815rcN808' => 'P4C8',
'N815rcN809' => 'P4C9',
'N815rcN810' => 'P4C10',
'N815rcN811' => 'P4C11',
'N815rcN812' => 'P4C12',
'N816rcN801' => 'P4D1',
'N816rcN802' => 'P4D2',
'N816rcN803' => 'P4D3',
'N816rcN804' => 'P4D4',
'N816rcN805' => 'P4D5',
'N816rcN806' => 'P4D6',
'N816rcN807' => 'P4D7',
'N816rcN808' => 'P4D8',
'N816rcN809' => 'P4D9',
'N816rcN810' => 'P4D10',
'N816rcN811' => 'P4D11',
'N816rcN812' => 'P4D12',
'N817rcN801' => 'P4E1',
'N817rcN802' => 'P4E2',
'N817rcN803' => 'P4E3',
'N817rcN804' => 'P4E4',
'N817rcN805' => 'P4E5',
'N817rcN806' => 'P4E6',
'N817rcN807' => 'P4E7',
'N817rcN808' => 'P4E8',
'N817rcN809' => 'P4E9',
'N817rcN810' => 'P4E10',
'N817rcN811' => 'P4E11',
'N817rcN812' => 'P4E12',
'N818rcN801' => 'P4F1',
'N818rcN802' => 'P4F2',
'N818rcN803' => 'P4F3',
'N818rcN804' => 'P4F4',
'N818rcN805' => 'P4F5',
'N818rcN806' => 'P4F6',
'N818rcN807' => 'P4F7',
'N818rcN808' => 'P4F8',
'N818rcN809' => 'P4F9',
'N818rcN810' => 'P4F10',
'N818rcN811' => 'P4F11',
'N818rcN812' => 'P4F12',
'N819rcN801' => 'P4G1',
'N819rcN802' => 'P4G2',
'N819rcN803' => 'P4G3',
'N819rcN804' => 'P4G4',
'N819rcN805' => 'P4G5',
'N819rcN806' => 'P4G6',
'N819rcN807' => 'P4G7',
'N819rcN808' => 'P4G8',
'N819rcN809' => 'P4G9',
'N819rcN810' => 'P4G10',
'N819rcN811' => 'P4G11',
'N819rcN812' => 'P4G12',
'N820rcN801' => 'P4H1',
'N820rcN802' => 'P4H2',
'N820rcN803' => 'P4H3',
'N820rcN804' => 'P4H4',
'N820rcN805' => 'P4H5',
'N820rcN806' => 'P4H6',
'N820rcN807' => 'P4H7',
'N820rcN808' => 'P4H8',
'N820rcN809' => 'P4H9',
'N820rcN810' => 'P4H10',
'N820rcN811' => 'P4H11',
'N820rcN812' => 'P4H12',
'N601rcN813' => 'P5A1',
'N602rcN813' => 'P5A2',
'N603rcN813' => 'P5A3',
'N604rcN813' => 'P5A4',
'N605rcN813' => 'P5A5',
'N606rcN813' => 'P5A6',
'N607rcN813' => 'P5A7',
'N608rcN813' => 'P5A8',
'N805rcN813' => 'P5A9',
'N806rcN813' => 'P5A10',
'N807rcN813' => 'P5A11',
'N808rcN813' => 'P5A12',
'N601rcN814' => 'P5B1',
'N602rcN814' => 'P5B2',
'N603rcN814' => 'P5B3',
'N604rcN814' => 'P5B4',
'N605rcN814' => 'P5B5',
'N606rcN814' => 'P5B6',
'N607rcN814' => 'P5B7',
'N608rcN814' => 'P5B8',
'N809rcN814' => 'P5B9',
'N810rcN814' => 'P5B10',
'N811rcN814' => 'P5B11',
'N812rcN814' => 'P5B12',
'N601rcN815' => 'P5C1',
'N602rcN815' => 'P5C2',
'N603rcN815' => 'P5C3',
'N604rcN815' => 'P5C4',
'N605rcN815' => 'P5C5',
'N606rcN815' => 'P5C6',
'N607rcN815' => 'P5C7',
'N608rcN815' => 'P5C8',
'N813rcN815' => 'P5C9',
'N814rcN815' => 'P5C10',
'N815rcN815' => 'P5C11',
'N816rcN815' => 'P5C12',
'N609rcN816' => 'P5D1',
'N610rcN816' => 'P5D2',
'N611rcN816' => 'P5D3',
'N612rcN816' => 'P5D4',
'N801rcN816' => 'P5D5',
'N802rcN816' => 'P5D6',
'N803rcN816' => 'P5D7',
'N804rcN816' => 'P5D8',
'N813rcN816' => 'P5D9',
'N814rcN816' => 'P5D10',
'N815rcN816' => 'P5D11',
'N816rcN816' => 'P5D12',
'N609rcN817' => 'P5E1',
'N610rcN817' => 'P5E2',
'N611rcN817' => 'P5E3',
'N612rcN817' => 'P5E4',
'N801rcN817' => 'P5E5',
'N802rcN817' => 'P5E6',
'N803rcN817' => 'P5E7',
'N804rcN817' => 'P5E8',
'N813rcN817' => 'P5E9',
'N814rcN817' => 'P5E10',
'N815rcN817' => 'P5E11',
'N816rcN817' => 'P5E12',
'N609rcN818' => 'P5F1',
'N610rcN818' => 'P5F2',
'N611rcN818' => 'P5F3',
'N612rcN818' => 'P5F4',
'N801rcN818' => 'P5F5',
'N802rcN818' => 'P5F6',
'N803rcN818' => 'P5F7',
'N804rcN818' => 'P5F8',
'N817rcN818' => 'P5F9',
'N818rcN818' => 'P5F10',
'N819rcN818' => 'P5F11',
'N820rcN818' => 'P5F12',
'N805rcN819' => 'P5G1',
'N806rcN819' => 'P5G2',
'N807rcN819' => 'P5G3',
'N808rcN819' => 'P5G4',
'N809rcN819' => 'P5G5',
'N810rcN819' => 'P5G6',
'N811rcN819' => 'P5G7',
'N812rcN819' => 'P5G8',
'N817rcN819' => 'P5G9',
'N818rcN819' => 'P5G10',
'N819rcN819' => 'P5G11',
'N820rcN819' => 'P5G12',
'N805rcN820' => 'P5H1',
'N806rcN820' => 'P5H2',
'N807rcN820' => 'P5H3',
'N808rcN820' => 'P5H4',
'N809rcN820' => 'P5H5',
'N810rcN820' => 'P5H6',
'N811rcN820' => 'P5H7',
'N812rcN820' => 'P5H8',
'N817rcN820' => 'P5H9',
'N818rcN820' => 'P5H10',
'N819rcN820' => 'P5H11',
'N820rcN820' => 'P5H12',
);
    return \%name;
}
