#! /bin/bash

###############################################################################
#
# Author: HeChen
#
###############################################################################


ref=hg38_chromosome_size.bed
fa=/PATH/TO/REFERENCE/hg38.fa

samtools view -uT $fa /PATH/TO/SINGLE/CELL/BAM/$name.sam|samtools sort -l9 -@8 - >samtools sort -l9 -@8 - >$name.bam
samtools view -uf3 -q20 -L $ref /PATH/TO/SINGLE/CELL/BAM/$name.bam | samtools sort -n -l0 -@8 - | samtools fixmate - - | samtools view -uf3 - | samtools sort -l9 -@8 - > /PATH/TO/SINGLE/CELL/BAM/$name.f3q20.bam
samtools rmdup /PATH/TO/SINGLE/CELL/BAM/$name.f3q20.bam - | samtools sort -n -l0 -@8 - | samtools fixmate - - | samtools view -uf3 - | samtools sort -l9 -@8 - > /PATH/TO/SINGLE/CELL/BAM/$name.clean.bam

samtools index /PATH/TO/SINGLE/CELL/BAM/$name.clean.bam
samtools bedcov $ref /PATH/TO/SINGLE/CELL/BAM/$name.clean.bam >/PATH/TO/SINGLE/CELL/BAM/$name.cov.bed
rm /PATH/TO/SINGLE/CELL/BAM/$name.f3q20.bam
