This folder contains scripts to process the barcodes from the promoter screen library. I randomly selected 12bp barcodes generated by the freebarcodes tool (Hawkins et al, 2018, doi:10.1073/pnas.1802640115, see their [github page](https://github.com/finkelsteinlab/freebarcodes)) in the library design and used the same tool to decode the barcodes. 

The reads are such that the promoter barcode (pBC) is in R1 and the genomic barcode (gBC) is in R2. Sample fastq files are provided in this folder. The full sequencing files are in GEO. 

1. Process the fastq file for input into the freebarcodes software. 

```
usage: generate_freebarcodes_input.py [-h] [-o OUTPUT] fastq_R1 fastq_R2 gBC

Changes the barcodes with N in them to a random ATCG because the free barcodes 
software does not accept them and find LP barcode and adds LP name to read
name

positional arguments:  
fastq_R1              fastq file read 1  
fastq_R2              fastq file read 2  
gBC                   file containing genomic barcodes
optional arguments:  
-h, --help            show this help message and exit  
-o OUTPUT, --output OUTPUT                        
                        output file basename
                        
```

Example: 

```
python3 generate_freebarcodes_input.py patchMPRA_DNA_sample.fastq.gz patchMPRA_DNA_sample_R2.fastq.gz LP_BCs -o sample_freebarcodes_input.gz
```

2. Run freebarcodes decoder. Barcode file and codebook is obtained from freebarcodes software.

Example: 

```
freebarcodes decode barcodes12-1.txt sample_freebarcodes_input.fastq 
```

3. Process the freebarcodes output to get the promoter barcodes, genomic locations and counts. 

```
usage: process_freebarcodes_output.py [-h] [-o OUTPUT] freebarcodes_output

Process freebarcodes output and output counts per barcode pair

positional arguments:  
freebarcodes_output   decoded freebarcodes file

optional arguments:  
-h, --help            show this help message and exit  
-o OUTPUT, --output OUTPUT                        
                        output file basename
```

Example:

```
python3 process_freebarcodes_output.py sample_freebarcodes_input_decoded.txt
```
