# python2.7
# -*- coding: utf-8 -*-

'''
Based on python2.7
use to plot coverage matrix generated by MainForCountCoverage.py.
'''
try:
    import matplotlib.pyplot as plt
    import pandas as pd
    import numpy as np
    from sklearn.preprocessing import minmax_scale
    # matplotlib.use('MacOSX') # need to add this for poping up the plt.show() window on the local computer, but do not use when running in jupiter or cluter
    plt.switch_backend('agg') # need to add this for running on the server, otherwise raising error 'Invalid DISPLAY variable'
except:
    print "module error"
    quit()


def make_square_axes(ax): # secondary function used by Plot()
    '''
    Make an axes square in screen units even with different limits.
    Should be called after plotting.
    '''
    ax.set_aspect(1 / ax.get_data_ratio())

def ReadMatrix(matrix, Endseq_cutoff):
    '''
    Endseq_cutoff: 
    For 5'end seq, only use transcripts with counts>=Endseq_cutoff for percent calculation and plotting.
    
    For RNAseq, Endseq_cutoff=-1 by default.

    input dataframe is generated by CaculateCountInTranscript()
    <transcript id><bin1><bin2>..<bin number-1>
    ENST00000470373.1  0       0       0       1 .... 0
    The number is the counts in this bin
    
    return a list which contains the sum of percent of all the transcript of each bin, percent=counts in bin/counts in all bin for each transcript,
    this number is used as y-axis for each bin, e.g.
    [array([1.00000000e+00, 4.26754952e-01, 2.65013808e-01, 1.90103854e-01,
    1.49628385e-01, 1.19917062e-01, 9.32113481e-02, 7.41145415e-02,
    6.23725292e-02, 5.54579906e-02, 4.72641487e-02, 3.99760036e-02,
    3.32002184e-02, 3.13425514e-02, 2.78999612e-02, 2.51073359e-02,
    2.17032374e-02, 2.12309416e-02, 1.90561859e-02, 1.86064959e-02,
    1.71015243e-02, 1.67968123e-02, 1.52854942e-02, 1.37416175e-02,
    1.24709680e-02, 1.18763976e-02, 1.03009306e-02, 1.01881804e-02,
    1.08858333e-02, 1.11438005e-02, 8.85487964e-03, 8.81109101e-03,
    8.32035372e-03, 8.30225998e-03, 6.79282415e-03, 7.83267796e-03,
    7.38142968e-03, 6.66263623e-03, 6.30316560e-03, 5.96763044e-03,
    5.79146904e-03, 6.29651941e-03, 5.98952229e-03, 4.54794263e-03,
    5.09748717e-03, 4.26377411e-03, 5.18497388e-03, 4.11153120e-03,
    4.78485716e-03, 4.55282063e-03, 4.75449636e-03, 4.53078393e-03,
    3.91245724e-03, 3.27584484e-03, 3.30857455e-03, 2.91328097e-03,
    3.94124903e-03, 3.70200292e-03, 3.47374840e-03, 3.51409529e-03,
    2.90058011e-03, 3.43727860e-03, 2.54842542e-03, 2.16007799e-03,
    2.42542575e-03, 2.35152689e-03, 2.10354697e-03, 2.70636314e-03,
    2.82708576e-03, 1.91909406e-03, 2.70455363e-03, 1.85319764e-03,
    2.36449596e-03, 1.07323070e-03, 1.42158214e-03, 1.47787824e-03,
    1.73848781e-03, 1.32499491e-03, 1.25416547e-03, 1.17152841e-03,
    1.76182913e-03, 1.11130167e-03, 1.55372870e-03, 1.66917529e-03,
    1.05923867e-03, 1.17310322e-03, 5.57951841e-04, 1.83380211e-03,
    1.03842585e-03, 1.28481157e-03, 1.06070376e-03, 8.93838289e-04,
    1.21318716e-03, 9.00398142e-04, 2.05417642e-04, 7.52779137e-04,
    8.51466964e-04, 6.66083012e-04, 0.00000000e+00, 1.77260641e-04]) 
    '''

    data = pd.read_csv(matrix, header=None, sep='\t').iloc[:,1:] # skip the transcript_id col
    
    if Endseq_cutoff <0: # Enseq_cutoff default = -1, this is for RNAseq or Endseq without applying Enseq_cutoff
        # df saving all the lines that do not have 0 for all the bins to reduce the processing data
        df = data.loc[(data!=0).any(1)]
        print "There are {} number of entries with at least 1 count in all the bins.".format(df.shape[0])
    else:
        # df saving all the lines with total counts>=Endseq_cutoff
        df = data.loc[(data.apply(np.sum, axis=1) >= Endseq_cutoff),:]
        print "Only use transcripts with counts>={} for percent calculation and plotting.".format(Endseq_cutoff)
        print "There are {} number of entries with at least {} count in all the bins.".format(df.shape[0], Endseq_cutoff)

    # normalize the TSS number in each bin to the total of the transcript -> percent
    # use the sum of percent of all the transcript as the y-axis for each bin
    df_copy = df.copy() # Create a copy to avoid SettingWithCopyWarning
    for i in df.index.values: # iterate through row index
        total = df.loc[i,:].sum()
        ls = df.loc[i,:].copy() # make a copy
        ls_percent = ls.apply(lambda x:float(x)/total) # convert counts of each bin to percent of total
        df_copy.loc[i] = [x for x in ls_percent]

    yaxis = minmax_scale(df_copy.sum(axis=0))
    return yaxis

def Plot(report_list, name_list, png, Endseq_cutoff):
    '''
    Plot the coverage of reports in report_list
    name_list: name of legend corresponding to the report in list
    '''

    fig = plt.figure(figsize=(5, 5), dpi=300) # single plot, dpi=300
    ax = plt.axes()

    if len(report_list)>6:
        color_pallet = plt.get_cmap("tab10") # Default tab10 color
    else:    
        color_pallet = ['#CC0029','#008200', '#3E5690', '#FF41FF', '#FFA500', 'FFFB00']
    
    # kwargs = dict(color='red', alpha=0.3, linewidth=2.5, linestyle="-") 
    
    for i in range(0, len(report_list)):
        coverage = ReadMatrix(report_list[i], Endseq_cutoff) # yaxis
        xaxis = np.linspace(0, 100, dtype=int, num=len(coverage))
        plt.plot(xaxis, coverage, color=color_pallet[i], lw=2.5, alpha=1, label = name_list[i])
        # plt.plot(xaxis, [float(item) for item in RNAseq.split()], color='#FF41FF', lw=2.5, alpha=1, label = 'RNAseqDel')
    
    # plt.axhline(y=0, linestyle='--', color='#999999') # Add y=0 line

    ax.set_xlabel('Relative Position in transcript (%)') # ax.set_xlabel('') to remove xlabel
    ax.set_ylabel('Normalized coverage (%)')
    ax.legend() # add legend labels
    make_square_axes(ax)
    plt.savefig(png, bbox_inches='tight')


