#################################################
#  File Name:bamtopeak.sh
#  Author: xingpengwei
#  Mail: xingwei421@qq.com
#  Created Time: Wed 07 Apr 2021 02:52:50 PM UTC
#################################################
#for i in `ls *gz`
#do
fastq=$1
out=`echo $fastq|sed s/.trim.gz//g`
mm9=/home/xingqichen/SOFTWARE/Code/ATAC-seq/ATAC-seq/Data/mm9_refseq_genes_TSS.bed
hg19=/home/xingqichen/SOFTWARE/Code/ATAC-seq/ATAC-seq/Data/hg19_refseq_genes_TSS.bed
ref_hg19=/home/xingqichen/SOFTWARE/References/hg19/hg19
ref_mm9=/home/xingqichen/SOFTWARE/References/mm9/mm9

bowtie2 --very-sensitive -p 20 -x $ref_mm9 -U $fastq -S $out.bowtie2.sam &> ${out}_bowtie2.txt
samtools view --threads 10 -S -b $out.bowtie2.sam > $out.bowtie2.bam
rm $out.bowtie2.sam
sambamba sort $out.bowtie2.bam -t 10 -o $out.sort.bam
samtools view -h $out.sort.bam |awk '$3!="chrM"' |samtools view -S -b |samtools sort - -o $out.sort.rmchrM.bam
#samtools view -h $out.sort.bam |awk '$3=="chrM" || NF<10' |samtools view -S -b -  > $out.chrM.bam
java -Xmx4G -jar /home/xingqichen/SOFTWARE/picard-tools-1.119/MarkDuplicates.jar INPUT=$out.sort.rmchrM.bam OUTPUT=$out.sort.rmdup.bam METRICS_FILE=$out.Picard_Metrics_unfiltered_bam.txt VALIDATION_STRINGENCY=LENIENT ASSUME_SORTED=true REMOVE_DUPLICATES=true &> $out.Picard.log
sambamba index $out.sort.rmdup.bam
#python2.7 /home/xingqichen/SOFTWARE/Code/ATAC-seq/ATAC-seq/Code/pyMakeVplot.py -a $out.sort.rmdup.bam -b $mm9  -p ends -e 2000 -u -v
bedtools bamtobed -i $out.sort.rmdup.bam > $out.sort.rmdup.bed
macs2  callpeak -t $out.sort.rmdup.bed -f BED  -g mm -q 0.01 -n $out --nomodel  --shift 0
#done
