# ================================ #
#  Generate the random sequences   #
# ================================ #

my_path = "...................."

h.pho = c("V","I","L","F","M","Y","W")
h.phi = c("K","R","D","E","Q","N","C","G","H","P","S","T","A")

upper.limits = c(30,50,70,100,150,200,1000)
for (i in seq(0.1,0.9,0.1)){
  count = 0
  for (size in c(20,30,50,70,100,150,200)){
    count = count + 1
    my.seqs.names = NULL
    my.seqs       = NULL
    for (n in seq(1,1000)){
      my.size = sample(seq(size,upper.limits[count]),size = 1)
      my.h.pho = sample(h.pho,size = round(my.size * i),replace = T)
      my.h.phi = sample(h.phi,size = my.size-round(my.size * i),replace = T)
      my.seq   = sample(c(my.h.pho,my.h.phi))
      my.seq   = paste(my.seq,collapse = '')
      my.seqs.names = c(my.seqs.names,paste("Sequence",n,"_",size,"-",upper.limits[count],"_",i,sep=""))
      my.seqs = c(my.seqs,my.seq)
    }
    write.fasta(sequences = as.list(my.seqs),names = my.seqs.names,file.out = paste(my_path,"Random_sequences/Size_&_Hydrophobicity/Sequences_",size,"-",upper.limits[count],"_",i*100,".fasta",sep=""))
  }
}