# Pipeline for constructing a random "Intergenic genome" 

cd ${my_path}/Random_sequences/Random_IGR
# First we start by deleting the "chromosome" feature from the Annotation GFF file
grep -v "chromosome" ${my_path}/De_novo_genes_ancestral_reconstruction/inputs/annotations/Scer.gff > Scer.gff

# We extract all the Intergenic nucletides from S cerevisiae genome using our homemade script 
python ${my_path}/De_novo_genes_ancestral_reconstruction/scripts/Extract_IGR.py -genome ${my_path}/De_novo_genes_ancestral_reconstruction/inputs/genomes/Scer.fas -gff Scer.gff -out Scer_IGR.nfasta

# We concatenate all the nucleotides into one single chromosome and generate a pseudoGFF file
# with a homemade script Concatenate_sequences.py
python ${my_path}/Random_sequences/Random_IGR/Concatenate_sequences.py -fasta Scer_IGR.nfasta -fasta Scer_IGR.nfasta

# We randomize the sequence 
python3 ${my_path}/Random_sequences/scripts/Randomize_nucleotides.py -fasta Scer_IGR_concatenated.nfasta -out Scer_IGR_randomized

# We extract all the Random IFGORFs with ORFtrack
orftrack -fna Scer_IGR_randomized.nfasta -gff Scer_IGR_concatenated.gff
orfget -fna Scer_IGR_randomized.nfasta -gff mapping_orf_Scer_IGR_randomized.gff -o Scer_Random -type both

sed -i'' "s|*||g"  Scer_Random.pfasta`

orfold -fna Scer_Random.pfasta -option HIT -barcodes True
