#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Wed Jul 28 11:29:33 2021

@author: christospapadopoulos
"""


import sys,os

def read_multiFASTA(fasta_file):
    dico = {}
    with open(fasta_file,'r') as fasta:
        for line in fasta:
            if line.startswith('>'):
                name = str(line.split()[0])[1:]
                dico[name] = ''
            elif line == '\n':
                continue
            else:
                seq = line.strip()
                dico[name] = dico[name] + seq
    return(dico) 



fasta_file = sys.argv[sys.argv.index("-fasta")+1]
fasta = read_multiFASTA(fasta_file)

name = os.path.basename(fasta_file)
name = os.path.splitext(name)[0]

CAT_SEQ = ''
for i in fasta:
    CAT_SEQ = CAT_SEQ + fasta[i]
    
CAT_SEQ = CAT_SEQ.replace("N","")
    
with open(name+"_concatenated.nfasta","w") as fasta_w , open(name+"_concatenated.gff","w") as gff_w:
    
    fasta_w.write(">{}\n{}\n".format("Sequence",CAT_SEQ))
    gff_w.write("Sequence_random\tSGD\tchromosome\t1\t{}\t.\t+\t.\tID=Sequence;Parent=Sequence".format(len(CAT_SEQ)))


    


