#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Fri Jul  2 15:40:19 2021

@author: christospapadopoulos
"""


import sys

def read_anc_ali(ali_file):
    dico = {}
    with open(ali_file,"r") as f:
        for line in f:
            if line.strip().startswith("frame"):
                name = line.split(":")[0].strip()
                if not name.endswith(")"):
                    continue
                dico[line.split(":")[0].strip()] = line.split(":")[1].strip().replace(".","1").replace("0","1")
    return(dico)



ali_file = sys.argv[sys.argv.index("-ali")+1]
ali_seqs = read_anc_ali(ali_file)

name = ali_file.split("/")[-1].split(".frags_ali")[0]

orfs_order = ['NULL']
for i in range(len(ali_seqs[list(ali_seqs.keys())[0]])):
    try:
        pos_char = []
        for j in ali_seqs:
            pos_char.append(ali_seqs[j][i])
    except:
        continue

    try:
        
        if pos_char.count("1") == 1:
            name_tmp = list(ali_seqs.keys())[pos_char.index('1')].split("(")[0].strip()
            if name_tmp != orfs_order[-1]:
                orfs_order.append(name_tmp)
        elif pos_char.count("1") > 1:
            for j,pos in enumerate(pos_char):
                if pos == '1':
                    name_tmp = list(ali_seqs.keys())[j].split("(")[0].strip()
                    if name_tmp not in orfs_order:
                        orfs_order.append(name_tmp)
    except:
        continue

orfs_order = orfs_order[1:]

events = []
for first, second in zip(orfs_order, orfs_order[1:]):
    if first.split("_part_")[0] == second.split("_part_")[0] :
        events.append("STOP")
    else:
        events.append("FS")
        
print(name,"\t",events.count("FS"),"\t",events.count("STOP"))

    
    
    




    
    


