#!/usr/bin/Rscript
args=commandArgs(TRUE)
if(length(args)!=1)
{
	print("Usage:  <op> ")
	q()
}

op=args[1]

#library(RColorBrewer)
pdf(paste(op, ".hypo20.EndDenistyFlanking1K.pdf", sep=''))
par(mar=c(5,5,5,5))
	
	df=read.table(paste(op, ".hypo20.EndDenistyFlanking1K.profile" ,sep=""), header=F)
	plot(df$V2/median(df$V2)~df$V1,type='l',ylab='Normalized end density',xlab='Relative distance (bp)', col='springgreen4',lwd=2,xlim=c(-1000,1000), ylim=c(0.5,2),  main=op)
	abline(v=0,lty=2,lwd=2,col='gray')
	plot(df$V2/median(df$V2)~df$V1,type='l',ylab='Normalized end density',xlab='Relative distance (bp)', col='springgreen4',lwd=2,xlim=c(-20,20),ylim=c(0.5,2), main=op, xaxt='n')
	abline(v=0,lty=2,lwd=2,col='gray')
	axis(1, at = seq(-20, 20, 4), las=1,cex.axis=1)
dev.off()
