#!/usr/bin/perl
use strict;
use warnings;


if(@ARGV!=2)
{
	warn "usage: <outprefix> <hg.fa>\n";
	exit 1;
}

my $outprefix=shift;

my $id;
my %fa;
while(<>)
{
	chomp;
	if(/>(\S+)/)
	{
		warn "loading $1...\n";
		$id=$1;
	}
	else
	{
		$fa{$id}.=$_;
	}
}

my %kmer;
open CG, ">$outprefix.CG.bed";

for(1..19, 'X', 'Y')
{
	my $chr="chr$_";
	next unless exists $fa{$chr};
	my $len=length($fa{$chr});
	for(my $idx=0; $idx!=$len; $idx++)
	{
		my $kmer=substr($fa{$chr}, $idx, 3);
		if($kmer!~/N/)
		{
			$kmer=uc $kmer;
			$kmer{$kmer}++;
			if($kmer=~/^CG/i)
			{
				print CG join("\t", $chr, $idx, $idx+1, "$chr:$idx", $kmer, 'CG'), "\n";
			}
		}
	}
}

close CG;

