#!/usr/bin/Rscript
args=commandArgs(TRUE)
#library(RColorBrewer)

if(length(args)!=1)
{
	print("Usage:  <op> ")
	q()
}

op=args[1]

features=c('TSS', 'h3k27ac', 'h3k4me3', 'polII', 'random')
pdf(paste(op, ".MD.pdf", sep=''))
par(mar=c(5,5,5,5))
for (i in features)
{
	dat=paste(op, ".", i, "*.meth",sep='')
	WT=Sys.glob(dat)
	print(WT)	
	df=read.table(WT[1],header=F)
	plot(df$V4~df$V1,type='l',ylab='CG Methylation(%)',xlab='Relative distance (bp)', col='springgreen4',main=i,lwd=0.5,ylim=c(0,80))

}

dev.off()

