#!/usr/bin/Rscript
#library(plotly)
library(RColorBrewer)
features=c('TSS', 'polII', 'random', 'h3k27ac', 'h3k4me3')
pdf("Markers.MethDensity.pdf")
par(mar=c(5,5,5,5))
#labc=c("#DC494C","#F88D51","#3F96B7","#27ae60")
for (i in features)
{
	wt=paste("*WT.", i, "*.meth",sep='')
	ko1=paste("*DNASE1KO.", i,"*.meth",sep='')
	ko1l3=paste("*DNASE1L3KO.", i, "*.meth", sep='')
	WT=Sys.glob(wt)
	KO1=Sys.glob(ko1)
	KO1L3=Sys.glob(ko1l3)
	print (WT)
	print (KO1)
	print (KO1L3)
	#pos    C.cnt   T.cnt   meth%
	#-100    217     2121    9.281437
	
	df=read.table(WT[1],header=F)
	plot(df$V4~df$V1,type='l',ylab='CG Methylation(%)',xlab='Relative distance (bp)', col='white',main=i,lwd=2,ylim=c(0,80))
	m=c()
	for (k in KO1)
	{
	        df=read.table(k,header=F)
		m=cbind(m,df$V4)
	        #lines(df$V4/median(df$V4)~df$V1,col='#F88D51',lwd=0.5)
	}
	med=apply(m, 1, median)
	lines(seq(-3000,3000),med,col='#3F96B7',lwd=0.5)

	m=c()
	for (k in WT)
	{
		df=read.table(k,header=F)
		#lines(df$V4/median(df$V4)~df$V1,col='#27ae60',lwd=0.5)
		m=cbind(m,df$V4)
	}
	med=apply(m, 1, median)
	lines(seq(-3000,3000),med,col='#27ae60',lwd=0.5)

		
	m=c()
	for (k in KO1L3)
	{
		df=read.table(k,header=F)
	        #lines(df$V4/median(df$V4)~df$V1,col='#3F96B7',lwd=0.5)
		m=cbind(m,df$V4)
	}
	med=apply(m, 1, median)
	lines(seq(-3000,3000),med,col='#DC494C',lwd=0.5)

	#legend("topright",inset=c(-0.3,0),legend=c("WT","1KO","1L3KO","DFFBKO"),col=c('#27ae60','#F88D51','#DC494C','#3F96B7'),bty='n',lty=1)
	legend("topright",inset=c(-0.3,0),legend=c("WT","1KO","1L3KO"),col=c('#27ae60','#3F96B7','#DC494C'),bty='n',lty=1)
	
	df=read.table(WT[1],header=F)
	plot(df$V4/median(df$V4)~df$V1,type='l',ylab='CG Methylation(%) (%)',xlab='Relative distance (bp)', col='white',main=i,lwd=2,xlim=c(-1000,1000),ylim=c(0,80))
	m=c()
	for (k in KO1)
	{
	        df=read.table(k,header=F)
		m=cbind(m,df$V4)
	        #lines(df$V4/median(df$V4)~df$V1,col='#F88D51',lwd=0.5)
	}
	med=apply(m, 1, median)
	lines(seq(-3000,3000),med,col='#3F96B7',lwd=0.5)

	m=c()
	for (k in WT)
	{
		df=read.table(k,header=F)
		#lines(df$V4/median(df$V4)~df$V1,col='#27ae60',lwd=0.5)
		m=cbind(m,df$V4)
	}
	med=apply(m, 1, median)
	lines(seq(-3000,3000),med,col='#27ae60',lwd=0.5)

	
	m=c()
	for (k in KO1L3)
	{
		df=read.table(k,header=F)
	        #lines(df$V4/median(df$V4)~df$V1,col='#3F96B7',lwd=0.5)
		m=cbind(m,df$V4)
	}
	med=apply(m, 1, median)
	lines(seq(-3000,3000),med,col='#DC494C',lwd=0.5)
	legend("topright",inset=c(-0.1,0),legend=c("WT","1KO","1L3KO"),col=c('#27ae60','#3F96B7','#DC494C'),bty='n',lty=1)

}
dev.off()
