#!/usr/bin/perl

use strict;
use warnings;

if(@ARGV!=3)
{
	warn "Usage: <*.bed> <W.call> <C.call>\n";
	exit 1;
}

my $bed=shift;
my $W_met=shift;
my $C_met=shift;

my %met;
my %anno;

#open IN, "perl -lane 'print join(\"\t\", \$F[0], \$F[1]-1, \$F[1], \$F[4], \$F[5]) if \$F[0]=~/chr\\d+/' $W_met $C_met | intersectBed -a stdin -b $bed -wo | " || die("$!");
open IN, "perl -lane 'print join(\"\t\", \$F[0], \$F[1]-1, \$F[1], \$F[4], \$F[5]) if \$F[0]=~/chr\\d+/' $W_met $C_met | bedtools intersect -a stdin -b $bed -wo | " || die("$!");

while(<IN>)
{
	chomp;
	my @F=split;
	my $cen=int(($F[6]+$F[7]+1)/2);
	my $idx=$F[1]+1-$cen;
	if($F[8])
	{
		if($F[8] eq '-')
		{
			$idx=-$idx;
		}
	}
	$met{$idx}{C}+=$F[3];
	$met{$idx}{T}+=$F[4];
	#$anno{$idx}=$F[9];
}
close IN;

for my $idx (-3000...3000)
{
	my $tot=(($met{$idx}{C}||0)+($met{$idx}{T}||0)) || 1;
	my $met=($met{$idx}{C}||0 )/$tot*100;
	print join("\t", $idx, $met{$idx}{C}||0, $met{$idx}{T}||0, $met), "\n";
}
