#!/usr/bin/Rscript
args=commandArgs(TRUE)
if(length(args)!=1)
{
		print("Usage:  <op> ")
	q()
}

op=args[1]

#library(RColorBrewer)
features=c('CGI', 'tss', 'h3k27ac', 'h3k4me3', 'polII', 'random')
pdf(paste(op, ".end.density.pdf", sep=''))
par(mar=c(5,5,5,5))
for (i in features)
{
	dat=paste(op, ".", i, "*.profile",sep='')
	WT=Sys.glob(dat)
	print(WT)	
			df=read.table(WT[1],header=F)
			plot(df$V2/median(df$V2)~df$V1,type='l',ylab='Normalized end density',xlab='Relative distance (bp)', col='springgreen4',main=i,lwd=2,ylim=c(0.5,4), xlim=c(-1000,1000))
}
dev.off()
